/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.ui.views;

import java.util.HashSet;
import org.eclipse.actf.mediator.MediatorEvent;
import org.eclipse.actf.ui.util.AbstractPartListener;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.visualization.blind.ui.actions.BlindSaveAction;
import org.eclipse.actf.visualization.blind.ui.actions.BlindVisualizationAction;
import org.eclipse.actf.visualization.blind.ui.internal.PartControlBlind;
import org.eclipse.actf.visualization.blind.ui.internal.SelectionListenerBlind;
import org.eclipse.actf.visualization.engines.blind.html.ui.actions.BlindOpenIdCssAction;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.ElementViewerManagerFactory;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IElementViewerManager;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IHighlightElementListener;
import org.eclipse.actf.visualization.engines.blind.ui.actions.BlindSettingAction;
import org.eclipse.actf.visualization.engines.blind.ui.actions.BlindVisualizationBrowserModeAction;
import org.eclipse.actf.visualization.ui.IVisualizationView;
import org.eclipse.actf.visualization.ui.VisualizationStatusLineContributionItem;
import org.eclipse.actf.visualization.ui.report.table.ResultTableLabelProvider;
import org.eclipse.actf.visualization.ui.report.table.ResultTableSorter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class BlindView
extends ViewPart
implements IVisualizationView {
    private IBaseLabelProvider baseLabelProvider;
    private ResultTableSorter viewerSorter;
    private IElementViewerManager elementViewerManager;
    private PartControlBlind partRightBlind;
    private HashSet<IWorkbenchPage> pageSet = new HashSet();
    private BlindVisualizationBrowserModeAction browserVisualizaton;

    public BlindView() {
        this.baseLabelProvider = new ResultTableLabelProvider();
        this.viewerSorter = new ResultTableSorter();
        this.elementViewerManager = ElementViewerManagerFactory.getInstance();
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iViewSite);
        this.setStatusLine();
    }

    public void createPartControl(Composite composite) {
        this.partRightBlind = new PartControlBlind(this, composite);
        this.getSite().getPage().addSelectionListener("org.eclipse.actf.visualization.ui.report.views.DetailedReportView", (ISelectionListener)new SelectionListenerBlind(this.partRightBlind));
        this.elementViewerManager.setHighlightElementListener((IHighlightElementListener)this.partRightBlind);
        this.addPartListener();
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        this.browserVisualizaton = new BlindVisualizationBrowserModeAction();
        iToolBarManager.add((IAction)new BlindVisualizationAction(this.partRightBlind));
        iToolBarManager.add((IAction)this.browserVisualizaton);
        iToolBarManager.add((IAction)new BlindSettingAction());
        iToolBarManager.add((IAction)new BlindSaveAction(this.partRightBlind));
        iToolBarManager.add((IAction)new BlindOpenIdCssAction());
        iToolBarManager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
    }

    public void setStatusMessage(String string) {
        IContributionItem[] iContributionItemArray = this.getViewSite().getActionBars().getStatusLineManager().getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            if (iContributionItemArray[n] != null && iContributionItemArray[n].getId().equals("org.eclipse.actf.visualization.VisualizationStatusLineContributionItemorg.eclipse.actf.visualization.blind.ui.views.BlindView")) {
                ((VisualizationStatusLineContributionItem)iContributionItemArray[n]).setStatusMessage(string);
            }
            ++n;
        }
    }

    public void setInfoMessage(String string) {
        IContributionItem[] iContributionItemArray = this.getViewSite().getActionBars().getStatusLineManager().getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            if (iContributionItemArray[n] != null && iContributionItemArray[n].getId().equals("org.eclipse.actf.visualization.VisualizationStatusLineContributionItemorg.eclipse.actf.visualization.blind.ui.views.BlindView")) {
                ((VisualizationStatusLineContributionItem)iContributionItemArray[n]).setInfoMessage(string);
            }
            ++n;
        }
    }

    private void initPage(IWorkbenchPage iWorkbenchPage) {
        if (this.pageSet.add(iWorkbenchPage)) {
            iWorkbenchPage.addPartListener((IPartListener2)new AbstractPartListener(){

                public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
                    IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                    if (iWorkbenchPart instanceof IVisualizationView) {
                        if (iWorkbenchPart.equals((Object)BlindView.this)) {
                            BlindView.this.elementViewerManager.activateElementViewer();
                        } else {
                            BlindView.this.elementViewerManager.hideElementViewer();
                        }
                    }
                }
            });
        }
    }

    private void addPartListener() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUIUtil.getActiveWindow();
        iWorkbenchWindow.addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage iWorkbenchPage) {
            }

            public void pageClosed(IWorkbenchPage iWorkbenchPage) {
                BlindView.this.pageSet.remove(iWorkbenchPage);
            }

            public void pageOpened(IWorkbenchPage iWorkbenchPage) {
                BlindView.this.initPage(iWorkbenchPage);
            }
        });
        IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
        if (iWorkbenchPage != null) {
            this.initPage(iWorkbenchPage);
        }
    }

    private void setStatusLine() {
        this.getViewSite().getActionBars().getStatusLineManager().add((IContributionItem)new VisualizationStatusLineContributionItem("org.eclipse.actf.visualization.blind.ui.views.BlindView"));
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.baseLabelProvider;
    }

    public ViewerSorter getTableSorter() {
        this.viewerSorter.reset();
        return this.viewerSorter;
    }

    public int getResultTableMode() {
        return 0;
    }

    public void doVisualize() {
        if (this.partRightBlind != null) {
            this.partRightBlind.doVisualize();
        }
    }

    public void modelserviceChanged(MediatorEvent mediatorEvent) {
        if (this.partRightBlind.isBrowserModeSupported(mediatorEvent.getModelServiceHolder())) {
            this.browserVisualizaton.setEnabled(true);
        } else {
            this.browserVisualizaton.setEnabled(false);
        }
    }

    public void modelserviceInputChanged(MediatorEvent mediatorEvent) {
    }

    public void reportChanged(MediatorEvent mediatorEvent) {
    }

    public void reportGeneratorChanged(MediatorEvent mediatorEvent) {
    }

    public void setVisualizeMode(int n) {
    }
}

