/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPSymbols;

public final class STPHeuristicScanner
implements STPSymbols {
    public static final int NOT_FOUND = -1;
    public static final int UNBOUND = -2;
    private static final char LBRACE = '{';
    private static final char RBRACE = '}';
    private static final char LPAREN = '(';
    private static final char RPAREN = ')';
    private static final char SEMICOLON = ';';
    private static final char COLON = ':';
    private static final char COMMA = ',';
    private static final char LBRACKET = '[';
    private static final char RBRACKET = ']';
    private static final char QUESTIONMARK = '?';
    private static final char EQUAL = '=';
    private static final char LANGLE = '<';
    private static final char RANGLE = '>';
    private static final char DOT = '.';
    private static final char MINUS = '-';
    private static final char PLUS = '+';
    private static final char TILDE = '~';
    private final IDocument fDocument;
    private final String fPartitioning;
    private final String fPartition;
    private char fChar;
    private int fPos;
    private ITypedRegion fCachedPartition = new TypedRegion(-1, 0, "__no_partition_at_all");
    private final StopCondition fNonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private static final StopCondition fNonWS = new NonWhitespace();
    private final StopCondition fNonIdent = new NonJavaIdentifierPartDefaultPartition();

    public STPHeuristicScanner(IDocument document, String partitioning, String partition) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        Assert.isLegal((partitioning != null ? 1 : 0) != 0);
        Assert.isLegal((partition != null ? 1 : 0) != 0);
        this.fDocument = document;
        this.fPartitioning = partitioning;
        this.fPartition = partition;
    }

    public STPHeuristicScanner(IDocument document) {
        this(document, "__stp_partitioning", "__dftl_partition_content_type");
    }

    public int getPosition() {
        return this.fPos;
    }

    public int nextToken(int start, int bound) {
        int pos = this.scanForward(start, bound, fNonWS);
        if (pos == -1) {
            return -1;
        }
        try {
            char ch = this.fDocument.getChar(pos);
            if (ch == '\"' || ch == '\'') {
                this.fChar = ch;
                this.fPos = this.fNonWSDefaultPart.nextPosition(pos, true);
                return 8;
            }
        }
        catch (BadLocationException ch) {
            // empty catch block
        }
        pos = this.scanForward(pos, bound, this.fNonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        ++this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ':': {
                switch (this.peekNextChar()) {
                    case ':': {
                        ++this.fPos;
                        return 20;
                    }
                }
                return 9;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 12;
            }
            case '<': {
                switch (this.peekNextChar()) {
                    case '<': {
                        ++this.fPos;
                        if (this.peekNextChar() == '<') {
                            ++this.fPos;
                            return 23;
                        }
                        return 21;
                    }
                    case '=': {
                        ++this.fPos;
                        return 8;
                    }
                }
                return 13;
            }
            case '>': {
                switch (this.peekNextChar()) {
                    case '>': {
                        ++this.fPos;
                        return 18;
                    }
                    case '=': {
                        ++this.fPos;
                        return 8;
                    }
                }
                return 14;
            }
            case '.': {
                return 15;
            }
            case '-': {
                switch (this.peekNextChar()) {
                    case '>': {
                        ++this.fPos;
                        return 19;
                    }
                }
                return 16;
            }
            case '+': {
                return 22;
            }
            case '~': {
                return 17;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String identOrKeyword;
            int from = pos;
            int to = (pos = this.scanForward(pos + 1, bound, this.fNonIdent)) == -1 ? (bound == -2 ? this.fDocument.getLength() : bound) : pos;
            try {
                identOrKeyword = this.fDocument.get(from, to - from);
            }
            catch (BadLocationException e) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return 8;
    }

    public int previousToken(int start, int bound) {
        int pos = this.scanBackward(start, bound, this.fNonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        --this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ':': {
                switch (this.peekPreviousChar()) {
                    case ':': {
                        --this.fPos;
                        return 20;
                    }
                }
                return 9;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                switch (this.peekPreviousChar()) {
                    case '<': 
                    case '>': {
                        --this.fPos;
                        return 8;
                    }
                }
                return 12;
            }
            case '<': {
                switch (this.peekPreviousChar()) {
                    case '<': {
                        --this.fPos;
                        return 21;
                    }
                }
                return 13;
            }
            case '>': {
                switch (this.peekPreviousChar()) {
                    case '>': {
                        --this.fPos;
                        return 18;
                    }
                    case '-': {
                        --this.fPos;
                        return 19;
                    }
                }
                return 14;
            }
            case '.': {
                return 15;
            }
            case '-': {
                return 16;
            }
            case '+': {
                return 22;
            }
            case '~': {
                return 17;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String identOrKeyword;
            int to = pos + 1;
            int from = (pos = this.scanBackward(pos - 1, bound, this.fNonIdent)) == -1 ? (bound == -2 ? 0 : bound + 1) : pos + 1;
            try {
                identOrKeyword = this.fDocument.get(from, to - from);
            }
            catch (BadLocationException e) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return 8;
    }

    private char peekNextChar() {
        if (this.fPos + 1 < this.fDocument.getLength()) {
            try {
                return this.fDocument.getChar(this.fPos + 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return '\uffff';
    }

    private char peekPreviousChar() {
        if (this.fPos >= 0) {
            try {
                return this.fDocument.getChar(this.fPos);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return '\uffff';
    }

    private int getToken(String s) {
        Assert.isNotNull((Object)s);
        switch (s.length()) {
            case 2: {
                if ("if".equals(s)) {
                    return 109;
                }
                if (!"do".equals(s)) break;
                return 1010;
            }
            case 3: {
                if ("for".equals(s)) {
                    return 1011;
                }
                if ("try".equals(s)) {
                    return 1012;
                }
                if (!"new".equals(s)) break;
                return 1026;
            }
            case 4: {
                if ("case".equals(s)) {
                    return 1013;
                }
                if ("else".equals(s)) {
                    return 1014;
                }
                if ("enum".equals(s)) {
                    return 1031;
                }
                if (!"goto".equals(s)) break;
                return 1021;
            }
            case 5: {
                if ("break".equals(s)) {
                    return 1015;
                }
                if ("catch".equals(s)) {
                    return 1016;
                }
                if ("class".equals(s)) {
                    return 1028;
                }
                if ("const".equals(s)) {
                    return 1036;
                }
                if ("while".equals(s)) {
                    return 1017;
                }
                if ("union".equals(s)) {
                    return 1030;
                }
                if ("using".equals(s)) {
                    return 1039;
                }
                if (!"throw".equals(s)) break;
                return 1035;
            }
            case 6: {
                if ("delete".equals(s)) {
                    return 1027;
                }
                if ("public".equals(s)) {
                    return 1025;
                }
                if ("return".equals(s)) {
                    return 1018;
                }
                if ("static".equals(s)) {
                    return 1019;
                }
                if ("struct".equals(s)) {
                    return 1029;
                }
                if ("switch".equals(s)) {
                    return 1020;
                }
                if (!"extern".equals(s)) break;
                return 1037;
            }
            case 7: {
                if ("default".equals(s)) {
                    return 1022;
                }
                if ("foreach".equals(s)) {
                    return 1042;
                }
                if ("private".equals(s)) {
                    return 1023;
                }
                if ("typedef".equals(s)) {
                    return 1038;
                }
                if (!"virtual".equals(s)) break;
                return 1032;
            }
            case 8: {
                if ("operator".equals(s)) {
                    return 1034;
                }
                if ("template".equals(s)) {
                    return 1040;
                }
                if (!"typename".equals(s)) break;
                return 1041;
            }
            case 9: {
                if ("namespace".equals(s)) {
                    return 1033;
                }
                if (!"protected".equals(s)) break;
                return 1024;
            }
        }
        return 2000;
    }

    public int findClosingPeer(int start, char openingPeer, char closingPeer) {
        return this.findClosingPeer(start, -2, openingPeer, closingPeer);
    }

    private int findClosingPeer(int start, int bound, char openingPeer, char closingPeer) {
        Assert.isLegal((start >= 0 ? 1 : 0) != 0);
        try {
            int depth = 1;
            --start;
            do {
                if ((start = this.scanForward(start + 1, bound, new CharacterMatch(new char[]{openingPeer, closingPeer}))) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(start) == openingPeer) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public int findOpeningPeer(int start, char openingPeer, char closingPeer) {
        return this.findOpeningPeer(start, -2, openingPeer, closingPeer);
    }

    public int findOpeningPeer(int start, int bound, char openingPeer, char closingPeer) {
        Assert.isLegal((start < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            CharacterMatch match = new CharacterMatch(new char[]{openingPeer, closingPeer});
            int depth = 1;
            ++start;
            do {
                if ((start = this.scanBackward(start - 1, bound, match)) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(start) == closingPeer) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public int findNonWhitespaceForwardInAnyPartition(int position, int bound) {
        return this.scanForward(position, bound, fNonWS);
    }

    public int findNonWhitespaceBackward(int position, int bound) {
        return this.scanBackward(position, bound, this.fNonWSDefaultPart);
    }

    private int scanForward(int start, int bound, StopCondition condition) {
        Assert.isLegal((start >= 0 ? 1 : 0) != 0);
        if (bound == -2) {
            bound = this.fDocument.getLength();
        }
        Assert.isLegal((bound <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start;
            while (this.fPos < bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, true)) {
                    return this.fPos;
                }
                this.fPos = condition.nextPosition(this.fPos, true);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    public int scanForward(int position, int bound, char ch) {
        return this.scanForward(position, bound, new CharacterMatch(ch));
    }

    private int scanBackward(int start, int bound, StopCondition condition) {
        if (bound == -2) {
            bound = -1;
        }
        Assert.isLegal((bound >= -1 ? 1 : 0) != 0);
        Assert.isLegal((start < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start;
            while (this.fPos > bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, false)) {
                    return this.fPos;
                }
                this.fPos = condition.nextPosition(this.fPos, false);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    private boolean isDefaultPartition(int position) {
        return this.fPartition.equals(this.getPartition(position).getType());
    }

    private ITypedRegion getPartition(int position) {
        if (!this.contains((IRegion)this.fCachedPartition, position)) {
            Assert.isTrue((position >= 0 ? 1 : 0) != 0);
            Assert.isTrue((position <= this.fDocument.getLength() ? 1 : 0) != 0);
            try {
                this.fCachedPartition = TextUtilities.getPartition((IDocument)this.fDocument, (String)this.fPartitioning, (int)position, (boolean)false);
            }
            catch (BadLocationException e) {
                this.fCachedPartition = new TypedRegion(position, 0, "__no_partition_at_all");
            }
        }
        return this.fCachedPartition;
    }

    private boolean contains(IRegion region, int position) {
        int offset = region.getOffset();
        return offset <= position && position < offset + region.getLength();
    }

    public boolean isBracelessBlockStart(int position, int bound) {
        if (position < 1) {
            return false;
        }
        switch (this.previousToken(position, bound)) {
            case 1010: 
            case 1014: {
                return true;
            }
            case 6: {
                position = this.findOpeningPeer(this.fPos, -2, '(', ')');
                if (position <= 0) break;
                switch (this.previousToken(position - 1, bound)) {
                    case 109: 
                    case 1011: 
                    case 1017: 
                    case 1042: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean looksLikeCompositeTypeDefinitionBackward(int start, int bound) {
        int token = this.previousToken(start - 1, bound);
        switch (token) {
            case 1029: 
            case 1030: 
            case 1031: {
                return true;
            }
            case 2000: {
                token = this.previousToken(this.getPosition(), bound);
                switch (token) {
                    case 1028: 
                    case 1029: 
                    case 1030: 
                    case 1031: {
                        return true;
                    }
                }
                token = this.previousToken(start - 1, bound);
                break;
            }
            default: {
                token = this.previousToken(start - 1, bound);
            }
        }
        if (token == 14) {
            this.findOpeningPeer(this.getPosition(), bound, '<', '>');
            token = this.previousToken(this.getPosition(), bound);
            if (token != 13) {
                return false;
            }
            token = this.previousToken(this.getPosition(), bound);
        }
        block17: while (token == 2000) {
            token = this.previousToken(this.getPosition(), bound);
            while (token == 9) {
                token = this.previousToken(this.getPosition(), bound);
                if (token != 9) break block17;
                token = this.previousToken(this.getPosition(), bound);
                if (token != 2000) break;
                token = this.previousToken(this.getPosition(), bound);
            }
            switch (token) {
                case 1032: {
                    token = this.previousToken(this.getPosition(), bound);
                }
                case 1023: 
                case 1024: 
                case 1025: {
                    token = this.previousToken(this.getPosition(), bound);
                    if (token == 1032) {
                        token = this.previousToken(this.getPosition(), bound);
                    }
                    if (token == 11) {
                        token = this.previousToken(this.getPosition(), bound);
                        if (token != 14) continue block17;
                        this.findOpeningPeer(this.getPosition(), bound, '<', '>');
                        token = this.previousToken(this.getPosition(), bound);
                        if (token != 13) {
                            return false;
                        }
                        token = this.previousToken(this.getPosition(), bound);
                        continue block17;
                    }
                    if (token != 9) {
                        return false;
                    }
                }
                case 9: {
                    token = this.previousToken(this.getPosition(), bound);
                    break block17;
                }
                case 11: {
                    token = this.previousToken(this.getPosition(), bound);
                    if (token != 14) continue block17;
                    this.findOpeningPeer(this.getPosition(), bound, '<', '>');
                    token = this.previousToken(this.getPosition(), bound);
                    if (token != 13) {
                        return false;
                    }
                    token = this.previousToken(this.getPosition(), bound);
                    continue block17;
                }
                case 2000: {
                    break block17;
                }
                default: {
                    return false;
                }
            }
        }
        if (token != 2000) {
            return false;
        }
        token = this.previousToken(this.getPosition(), bound);
        switch (token) {
            case 1028: 
            case 1029: 
            case 1030: 
            case 1031: {
                return true;
            }
        }
        return false;
    }

    private final class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        private NonWhitespaceDefaultPartition() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) && STPHeuristicScanner.this.isDefaultPartition(position);
        }

        @Override
        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = STPHeuristicScanner.this.getPartition(position);
            if (STPHeuristicScanner.this.fPartition.equals(partition.getType())) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    private static abstract class StopCondition {
        private StopCondition() {
        }

        public abstract boolean stop(char var1, int var2, boolean var3);

        public int nextPosition(int position, boolean forward) {
            return forward ? position + 1 : position - 1;
        }
    }

    private final class NonJavaIdentifierPartDefaultPartition
    extends NonJavaIdentifierPart {
        private NonJavaIdentifierPartDefaultPartition() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) || !STPHeuristicScanner.this.isDefaultPartition(position);
        }

        @Override
        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = STPHeuristicScanner.this.getPartition(position);
            if (STPHeuristicScanner.this.fPartition.equals(partition.getType())) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    private final class CharacterMatch
    extends StopCondition {
        private final char[] fChars;

        public CharacterMatch(char ch) {
            this(new char[]{ch});
        }

        public CharacterMatch(char[] chars) {
            Assert.isNotNull((Object)chars);
            Assert.isTrue((chars.length > 0 ? 1 : 0) != 0);
            this.fChars = chars;
            Arrays.sort(chars);
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return Arrays.binarySearch(this.fChars, ch) >= 0 && STPHeuristicScanner.this.isDefaultPartition(position);
        }

        @Override
        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = STPHeuristicScanner.this.getPartition(position);
            if (STPHeuristicScanner.this.fPartition.equals(partition.getType())) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    private static class NonWhitespace
    extends StopCondition {
        private NonWhitespace() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isWhitespace(ch);
        }
    }

    private static class NonJavaIdentifierPart
    extends StopCondition {
        private NonJavaIdentifierPart() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isJavaIdentifierPart(ch);
        }
    }
}

