/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.core.IType;
import org.eclipse.viatra.transformation.debug.communication.IDebuggerHostAgent;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugElement;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugProcess;
import org.eclipse.viatra.transformation.debug.model.TransformationThread;
import org.eclipse.viatra.transformation.debug.model.TransformationThreadFactory;
import org.eclipse.viatra.transformation.debug.model.breakpoint.ITransformationBreakpointHandler;

public class TransformationDebugTarget
extends TransformationDebugElement
implements IDebugTarget {
    private TransformationDebugProcess process;
    private ILaunch launch;
    private String name;
    private List<TransformationThread> threads = new ArrayList<TransformationThread>();
    private boolean terminated = false;

    public TransformationDebugTarget(ILaunch launch, IDebuggerHostAgent agent, IType transformationType) {
        super(null);
        this.launch = launch;
        this.name = "Model Transformation Debugger Session";
        this.process = new TransformationDebugProcess(launch, this.name);
        this.threads.add(TransformationThreadFactory.getInstance().createTransformationThread(agent, this, transformationType));
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.fireCreationEvent();
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads.toArray(new IThread[0]);
    }

    public boolean hasThreads() throws DebugException {
        return !this.threads.isEmpty();
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof ITransformationBreakpointHandler;
    }

    public boolean canTerminate() {
        return !this.terminated;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
        for (TransformationThread transformationThread : this.threads) {
            transformationThread.terminate();
        }
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        for (TransformationThread transformationThread : this.threads) {
            if (!transformationThread.isSuspended()) continue;
            return true;
        }
        return false;
    }

    public void suspend() throws DebugException {
        for (TransformationThread transformationThread : this.threads) {
            transformationThread.suspend();
        }
    }

    public void resume() throws DebugException {
        for (TransformationThread transformationThread : this.threads) {
            transformationThread.resume();
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
        throw new UnsupportedOperationException("Disconnect is not supported");
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    protected void requestTermination() {
        this.terminated = true;
        this.fireTerminateEvent();
    }
}

