/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.PackageRefactoringContext;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands.AbstractDecoratorModelRefactoringCommand;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands.DirectionConstraint;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands.LoadedDecoratorModelRefactoringCommand;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands.SaveModelCommand;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands.UnloadedDecoratorModelRefactoringCommand;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.AbstractDecoratorModelUpdater;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.CrossReferenceUpdater;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.LoadedDecoratorModelUpdaterDelegate;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.PostControlDecoratorModelUpdater;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.PostUncontrolDecoratorModelUpdater;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.UnloadedDecoratorModelUpdaterDelegate;

public class DecoratorModelRefactoringCommandFactory {
    private DecoratorModelRefactoringCommandFactory() {
    }

    public static ICommand createPreCommand(ControlModeRequest request) throws CoreException {
        AbstractDecoratorModelRefactoringCommand refactoringCommand;
        PackageRefactoringContext context = PackageRefactoringContext.getInstance(request);
        if (context == null) {
            return null;
        }
        boolean needsSave = false;
        CompositeTransactionalCommand result = new CompositeTransactionalCommand(context.getEditingDomain(), Messages.DecoratorModelRefactoringCommandFactory_0);
        for (URI decoratorModel : context.getAffectedLoadedDecoratorModels()) {
            AbstractDecoratorModelRefactoringCommand abstractDecoratorModelRefactoringCommand = refactoringCommand = request.isControlRequest() ? DecoratorModelRefactoringCommandFactory.createPreControlLoaded(context, decoratorModel) : DecoratorModelRefactoringCommandFactory.createPreUncontrolLoaded(context, decoratorModel);
            if (refactoringCommand == null) continue;
            result.add((IUndoableOperation)refactoringCommand);
        }
        for (URI decoratorModel : context.getAffectedUnloadedDecoratorModels()) {
            AbstractDecoratorModelRefactoringCommand abstractDecoratorModelRefactoringCommand = refactoringCommand = request.isControlRequest() ? DecoratorModelRefactoringCommandFactory.createPreControlUnloaded(context, decoratorModel) : DecoratorModelRefactoringCommandFactory.createPreUncontrolUnloaded(context, decoratorModel);
            if (refactoringCommand == null) continue;
            result.add((IUndoableOperation)refactoringCommand);
            needsSave = true;
        }
        if (result.isEmpty()) {
            result = null;
        } else if (needsSave) {
            result.add((IUndoableOperation)new SaveModelCommand(context));
        }
        context.autoRelease();
        return result;
    }

    private static RefactoringStepStore getStore(PackageRefactoringContext context, URI decoratorModel) {
        RefactoringStepStore result = (RefactoringStepStore)context.getContextData().get(decoratorModel);
        if (result == null) {
            result = new RefactoringStepStore();
            context.getContextData().put(decoratorModel, result);
        }
        return result;
    }

    static CrossReferenceUpdater getCrossReferenceUpdater(PackageRefactoringContext context, URI decoratorModel) {
        RefactoringStepStore store = DecoratorModelRefactoringCommandFactory.getStore(context, decoratorModel);
        if (store.crossReferences == null) {
            store.crossReferences = new CrossReferenceUpdater(context, decoratorModel);
        }
        return store.crossReferences;
    }

    static AbstractDecoratorModelUpdater getProfileApplicationsUpdater(PackageRefactoringContext context, URI decoratorModel) {
        RefactoringStepStore store = DecoratorModelRefactoringCommandFactory.getStore(context, decoratorModel);
        return store.profileApplications;
    }

    static void setProfileApplicationsUpdater(PackageRefactoringContext context, URI decoratorModel, AbstractDecoratorModelUpdater updater) {
        RefactoringStepStore store = DecoratorModelRefactoringCommandFactory.getStore(context, decoratorModel);
        store.profileApplications = updater;
    }

    static AbstractDecoratorModelRefactoringCommand createPreControlLoaded(PackageRefactoringContext context, URI decoratorModel) {
        return null;
    }

    static AbstractDecoratorModelRefactoringCommand createPreControlUnloaded(PackageRefactoringContext context, URI decoratorModel) {
        CrossReferenceUpdater crossReferenceUpdater = DecoratorModelRefactoringCommandFactory.getCrossReferenceUpdater(context, decoratorModel);
        AbstractDecoratorModelUpdater profileApplicationUpdater = DecoratorModelRefactoringCommandFactory.getProfileApplicationsUpdater(context, decoratorModel);
        if (profileApplicationUpdater == null) {
            profileApplicationUpdater = new PostControlDecoratorModelUpdater(new UnloadedDecoratorModelUpdaterDelegate(context.getPackage()), context, decoratorModel);
            DecoratorModelRefactoringCommandFactory.setProfileApplicationsUpdater(context, decoratorModel, profileApplicationUpdater);
        }
        return new UnloadedDecoratorModelRefactoringCommand(context, decoratorModel, DirectionConstraint.UNREFACTOR_ONLY).addStep(profileApplicationUpdater).addStep(crossReferenceUpdater);
    }

    static AbstractDecoratorModelRefactoringCommand createPreUncontrolLoaded(PackageRefactoringContext context, URI decoratorModel) {
        return null;
    }

    static AbstractDecoratorModelRefactoringCommand createPreUncontrolUnloaded(PackageRefactoringContext context, URI decoratorModel) {
        CrossReferenceUpdater crossReferenceUpdater = DecoratorModelRefactoringCommandFactory.getCrossReferenceUpdater(context, decoratorModel);
        AbstractDecoratorModelUpdater profileApplicationUpdater = DecoratorModelRefactoringCommandFactory.getProfileApplicationsUpdater(context, decoratorModel);
        if (profileApplicationUpdater == null) {
            profileApplicationUpdater = new PostUncontrolDecoratorModelUpdater(new UnloadedDecoratorModelUpdaterDelegate(context.getPackage()), context, decoratorModel);
            DecoratorModelRefactoringCommandFactory.setProfileApplicationsUpdater(context, decoratorModel, profileApplicationUpdater);
        }
        return new UnloadedDecoratorModelRefactoringCommand(context, decoratorModel, DirectionConstraint.UNREFACTOR_ONLY).addStep(profileApplicationUpdater).addStep(crossReferenceUpdater);
    }

    public static ICommand createPostCommand(ControlModeRequest request) throws CoreException {
        AbstractDecoratorModelRefactoringCommand refactoringCommand;
        PackageRefactoringContext context = PackageRefactoringContext.getInstance(request);
        if (context == null) {
            return null;
        }
        boolean needsSave = false;
        CompositeTransactionalCommand result = new CompositeTransactionalCommand(context.getEditingDomain(), Messages.DecoratorModelRefactoringCommandFactory_0);
        for (URI decoratorModel : context.getAffectedLoadedDecoratorModels()) {
            AbstractDecoratorModelRefactoringCommand abstractDecoratorModelRefactoringCommand = refactoringCommand = request.isControlRequest() ? DecoratorModelRefactoringCommandFactory.createPostControlLoaded(context, decoratorModel) : DecoratorModelRefactoringCommandFactory.createPostUncontrolLoaded(context, decoratorModel);
            if (refactoringCommand == null) continue;
            result.add((IUndoableOperation)refactoringCommand);
        }
        for (URI decoratorModel : context.getAffectedUnloadedDecoratorModels()) {
            AbstractDecoratorModelRefactoringCommand abstractDecoratorModelRefactoringCommand = refactoringCommand = request.isControlRequest() ? DecoratorModelRefactoringCommandFactory.createPostControlUnloaded(context, decoratorModel) : DecoratorModelRefactoringCommandFactory.createPostUncontrolUnloaded(context, decoratorModel);
            if (refactoringCommand == null) continue;
            result.add((IUndoableOperation)refactoringCommand);
            needsSave = true;
        }
        if (result.isEmpty()) {
            result = null;
        } else if (needsSave) {
            result.add((IUndoableOperation)new SaveModelCommand(context));
        }
        context.autoRelease();
        return result;
    }

    static AbstractDecoratorModelRefactoringCommand createPostControlLoaded(PackageRefactoringContext context, URI decoratorModel) {
        AbstractDecoratorModelUpdater profileApplicationUpdater = DecoratorModelRefactoringCommandFactory.getProfileApplicationsUpdater(context, decoratorModel);
        if (profileApplicationUpdater == null) {
            profileApplicationUpdater = new PostControlDecoratorModelUpdater(new LoadedDecoratorModelUpdaterDelegate(context.getPackage()), context, decoratorModel);
            DecoratorModelRefactoringCommandFactory.setProfileApplicationsUpdater(context, decoratorModel, profileApplicationUpdater);
        }
        return new LoadedDecoratorModelRefactoringCommand(context, decoratorModel).addStep(profileApplicationUpdater);
    }

    static AbstractDecoratorModelRefactoringCommand createPostControlUnloaded(PackageRefactoringContext context, URI decoratorModel) {
        CrossReferenceUpdater crossReferenceUpdater = DecoratorModelRefactoringCommandFactory.getCrossReferenceUpdater(context, decoratorModel);
        AbstractDecoratorModelUpdater profileApplicationUpdater = DecoratorModelRefactoringCommandFactory.getProfileApplicationsUpdater(context, decoratorModel);
        if (profileApplicationUpdater == null) {
            profileApplicationUpdater = new PostControlDecoratorModelUpdater(new UnloadedDecoratorModelUpdaterDelegate(context.getPackage()), context, decoratorModel);
            DecoratorModelRefactoringCommandFactory.setProfileApplicationsUpdater(context, decoratorModel, profileApplicationUpdater);
        }
        return new UnloadedDecoratorModelRefactoringCommand(context, decoratorModel, DirectionConstraint.REFACTOR_ONLY).addStep(crossReferenceUpdater).addStep(profileApplicationUpdater);
    }

    static AbstractDecoratorModelRefactoringCommand createPostUncontrolLoaded(PackageRefactoringContext context, URI decoratorModel) {
        AbstractDecoratorModelUpdater profileApplicationUpdater = DecoratorModelRefactoringCommandFactory.getProfileApplicationsUpdater(context, decoratorModel);
        if (profileApplicationUpdater == null) {
            profileApplicationUpdater = new PostUncontrolDecoratorModelUpdater(new LoadedDecoratorModelUpdaterDelegate(context.getPackage()), context, decoratorModel);
            DecoratorModelRefactoringCommandFactory.setProfileApplicationsUpdater(context, decoratorModel, profileApplicationUpdater);
        }
        return new LoadedDecoratorModelRefactoringCommand(context, decoratorModel).addStep(profileApplicationUpdater);
    }

    static AbstractDecoratorModelRefactoringCommand createPostUncontrolUnloaded(PackageRefactoringContext context, URI decoratorModel) {
        CrossReferenceUpdater crossReferenceUpdater = DecoratorModelRefactoringCommandFactory.getCrossReferenceUpdater(context, decoratorModel);
        AbstractDecoratorModelUpdater profileApplicationUpdater = DecoratorModelRefactoringCommandFactory.getProfileApplicationsUpdater(context, decoratorModel);
        if (profileApplicationUpdater == null) {
            profileApplicationUpdater = new PostUncontrolDecoratorModelUpdater(new UnloadedDecoratorModelUpdaterDelegate(context.getPackage()), context, decoratorModel);
            DecoratorModelRefactoringCommandFactory.setProfileApplicationsUpdater(context, decoratorModel, profileApplicationUpdater);
        }
        return new UnloadedDecoratorModelRefactoringCommand(context, decoratorModel, DirectionConstraint.REFACTOR_ONLY).addStep(crossReferenceUpdater).addStep(profileApplicationUpdater);
    }

    private static class RefactoringStepStore {
        CrossReferenceUpdater crossReferences;
        AbstractDecoratorModelUpdater profileApplications;

        private RefactoringStepStore() {
        }
    }
}

