/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.tree;

import java.util.List;
import java.util.Map;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.dialog.IDialog;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.tree.item.AbstractTreeItem;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.tree.menu.AbstractTreeMenu;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.tree.menu.ExtendedTreeMenu;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;

public class ExtendedTree {
    private static final int TREE_HEIGHT = 250;
    private final Tree tree;
    private final ExtendedTreeMenu<IDialog> treeMenu;
    private Listener listener;

    public ExtendedTree(Composite parent, List<AbstractTreeMenu<IDialog>> menuItems) {
        this.tree = new Tree(parent, 4);
        GridData gridData = new GridData(768);
        gridData.heightHint = 250;
        this.tree.setLayoutData((Object)gridData);
        this.tree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                ExtendedTree.this.onMouseDoubleClick();
            }
        });
        this.tree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
            }

            public void keyPressed(KeyEvent event) {
                ExtendedTree.this.onKeyPressed(event);
            }
        });
        this.treeMenu = new ExtendedTreeMenu((Control)parent, this, menuItems);
        this.getTreeMenu().createMenu();
        this.tree.setMenu(this.getTreeMenu().getMenu());
    }

    protected void onKeyPressed(KeyEvent event) {
        if (event.keyCode == 127) {
            this.getTreeMenu().removeCurrentItemSelected();
        }
    }

    protected void onMouseDoubleClick() {
        if (this.getTree().getSelection().length > 0) {
            this.getTreeMenu().onMouseSelection();
        }
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void fireChanged() {
        this.listener.handleEvent(null);
    }

    public void putExtraPropertiesToItems(Map<String, Object> properties) {
        this.getTreeMenu().putExtraProperties(properties);
    }

    public AbstractTreeItem<IDialog> getFirstTreeItem() {
        AbstractTreeItem<IDialog> result = null;
        if (this.tree.getItemCount() > 0) {
            result = this.getTreeMenu().getTreeItemExtended(this.tree.getItem(0));
        }
        return result;
    }

    public ExtendedTreeMenu<IDialog> getTreeMenu() {
        return this.treeMenu;
    }
}

