/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.git.impl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ReflogCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.SubmoduleUpdateCommand;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.git.ConfigProperty;
import org.eclipse.oomph.setup.git.ConfigSection;
import org.eclipse.oomph.setup.git.GitCloneTask;
import org.eclipse.oomph.setup.git.GitPackage;
import org.eclipse.oomph.setup.git.impl.Messages;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.util.FileUtil;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitCloneTaskImpl
extends SetupTaskImpl
implements GitCloneTask {
    protected static final String LOCATION_EDEFAULT = "";
    protected String location = "";
    protected static final String LOCATION_QUALIFIER_EDEFAULT = " ";
    protected String locationQualifier = " ";
    protected static final String REMOTE_NAME_EDEFAULT = "origin";
    protected String remoteName = "origin";
    protected static final String REMOTE_URI_EDEFAULT = null;
    protected String remoteURI = REMOTE_URI_EDEFAULT;
    protected static final String PUSH_URI_EDEFAULT = null;
    protected String pushURI = PUSH_URI_EDEFAULT;
    protected static final String CHECKOUT_BRANCH_EDEFAULT = "${scope.project.stream.name}";
    protected String checkoutBranch = "${scope.project.stream.name}";
    protected static final boolean RECURSIVE_EDEFAULT = false;
    protected boolean recursive = false;
    protected EList<ConfigSection> configSections;
    protected static final boolean RESTRICT_TO_CHECKOUT_BRANCH_EDEFAULT = false;
    protected boolean restrictToCheckoutBranch = false;
    private boolean workDirExisted;
    private File workDir;
    private boolean hasCheckout;
    private Git cachedGit;
    private Repository cachedRepository;
    private Object repositoryUtil;
    private boolean bypassCloning;
    private int timeout;

    protected GitCloneTaskImpl() {
    }

    protected EClass eStaticClass() {
        return GitPackage.Literals.GIT_CLONE_TASK;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String newLocation) {
        String oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldLocation, (Object)this.location));
        }
    }

    @Override
    public String getLocationQualifier() {
        return this.locationQualifier;
    }

    @Override
    public void setLocationQualifier(String newLocationQualifier) {
        String oldLocationQualifier = this.locationQualifier;
        this.locationQualifier = newLocationQualifier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldLocationQualifier, (Object)this.locationQualifier));
        }
    }

    @Override
    public String getRemoteName() {
        return this.remoteName;
    }

    @Override
    public void setRemoteName(String newRemoteName) {
        String oldRemoteName = this.remoteName;
        this.remoteName = newRemoteName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldRemoteName, (Object)this.remoteName));
        }
    }

    @Override
    public String getRemoteURI() {
        return this.remoteURI;
    }

    @Override
    public void setRemoteURI(String newRemoteURI) {
        String oldRemoteURI = this.remoteURI;
        this.remoteURI = newRemoteURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldRemoteURI, (Object)this.remoteURI));
        }
    }

    @Override
    public String getCheckoutBranch() {
        return this.checkoutBranch;
    }

    @Override
    public void setCheckoutBranch(String newCheckoutBranch) {
        String oldCheckoutBranch = this.checkoutBranch;
        this.checkoutBranch = newCheckoutBranch;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldCheckoutBranch, (Object)this.checkoutBranch));
        }
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public void setRecursive(boolean newRecursive) {
        boolean oldRecursive = this.recursive;
        this.recursive = newRecursive;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldRecursive, this.recursive));
        }
    }

    @Override
    public EList<ConfigSection> getConfigSections() {
        if (this.configSections == null) {
            this.configSections = new EObjectContainmentEList(ConfigSection.class, (InternalEObject)this, 17);
        }
        return this.configSections;
    }

    @Override
    public boolean isRestrictToCheckoutBranch() {
        return this.restrictToCheckoutBranch;
    }

    @Override
    public void setRestrictToCheckoutBranch(boolean newRestrictToCheckoutBranch) {
        boolean oldRestrictToCheckoutBranch = this.restrictToCheckoutBranch;
        this.restrictToCheckoutBranch = newRestrictToCheckoutBranch;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, oldRestrictToCheckoutBranch, this.restrictToCheckoutBranch));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 17: {
                return ((InternalEList)this.getConfigSections()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public String getPushURI() {
        return this.pushURI;
    }

    @Override
    public void setPushURI(String newPushURI) {
        String oldPushURI = this.pushURI;
        this.pushURI = newPushURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldPushURI, (Object)this.pushURI));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getLocation();
            }
            case 11: {
                return this.getLocationQualifier();
            }
            case 12: {
                return this.getRemoteName();
            }
            case 13: {
                return this.getRemoteURI();
            }
            case 14: {
                return this.getPushURI();
            }
            case 15: {
                return this.getCheckoutBranch();
            }
            case 16: {
                return this.isRecursive();
            }
            case 17: {
                return this.getConfigSections();
            }
            case 18: {
                return this.isRestrictToCheckoutBranch();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setLocation((String)newValue);
                return;
            }
            case 11: {
                this.setLocationQualifier((String)newValue);
                return;
            }
            case 12: {
                this.setRemoteName((String)newValue);
                return;
            }
            case 13: {
                this.setRemoteURI((String)newValue);
                return;
            }
            case 14: {
                this.setPushURI((String)newValue);
                return;
            }
            case 15: {
                this.setCheckoutBranch((String)newValue);
                return;
            }
            case 16: {
                this.setRecursive((Boolean)newValue);
                return;
            }
            case 17: {
                this.getConfigSections().clear();
                this.getConfigSections().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.setRestrictToCheckoutBranch((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 11: {
                this.setLocationQualifier(LOCATION_QUALIFIER_EDEFAULT);
                return;
            }
            case 12: {
                this.setRemoteName(REMOTE_NAME_EDEFAULT);
                return;
            }
            case 13: {
                this.setRemoteURI(REMOTE_URI_EDEFAULT);
                return;
            }
            case 14: {
                this.setPushURI(PUSH_URI_EDEFAULT);
                return;
            }
            case 15: {
                this.setCheckoutBranch(CHECKOUT_BRANCH_EDEFAULT);
                return;
            }
            case 16: {
                this.setRecursive(false);
                return;
            }
            case 17: {
                this.getConfigSections().clear();
                return;
            }
            case 18: {
                this.setRestrictToCheckoutBranch(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 11: {
                return LOCATION_QUALIFIER_EDEFAULT == null ? this.locationQualifier != null : !LOCATION_QUALIFIER_EDEFAULT.equals(this.locationQualifier);
            }
            case 12: {
                return REMOTE_NAME_EDEFAULT == null ? this.remoteName != null : !REMOTE_NAME_EDEFAULT.equals(this.remoteName);
            }
            case 13: {
                return REMOTE_URI_EDEFAULT == null ? this.remoteURI != null : !REMOTE_URI_EDEFAULT.equals(this.remoteURI);
            }
            case 14: {
                return PUSH_URI_EDEFAULT == null ? this.pushURI != null : !PUSH_URI_EDEFAULT.equals(this.pushURI);
            }
            case 15: {
                return CHECKOUT_BRANCH_EDEFAULT == null ? this.checkoutBranch != null : !CHECKOUT_BRANCH_EDEFAULT.equals(this.checkoutBranch);
            }
            case 16: {
                return this.recursive;
            }
            case 17: {
                return this.configSections != null && !this.configSections.isEmpty();
            }
            case 18: {
                return this.restrictToCheckoutBranch;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (location: ");
        result.append(this.location);
        result.append(", locationQualifier: ");
        result.append(this.locationQualifier);
        result.append(", remoteName: ");
        result.append(this.remoteName);
        result.append(", remoteURI: ");
        result.append(this.remoteURI);
        result.append(", pushURI: ");
        result.append(this.pushURI);
        result.append(", checkoutBranch: ");
        result.append(this.checkoutBranch);
        result.append(", recursive: ");
        result.append(this.recursive);
        result.append(", restrictToCheckoutBranch: ");
        result.append(this.restrictToCheckoutBranch);
        result.append(')');
        return result.toString();
    }

    public Object getOverrideToken() {
        String token = this.getLocation();
        if (StringUtil.isEmpty((String)token)) {
            token = this.getRemoteURI();
        }
        return this.createToken(token);
    }

    public void overrideFor(SetupTask overriddenSetupTask) {
        super.overrideFor(overriddenSetupTask);
        GitCloneTask gitCloneTask = (GitCloneTask)overriddenSetupTask;
        if (!ObjectUtil.equals((Object)gitCloneTask.getRemoteURI(), (Object)this.getRemoteURI()) || !ObjectUtil.equals((Object)gitCloneTask.getCheckoutBranch(), (Object)this.getCheckoutBranch())) {
            Annotation errorAnnotation = BaseFactory.eINSTANCE.createErrorAnnotation(Messages.GitCloneTaskImpl_CloneCollision_message);
            this.getAnnotations().add((Object)errorAnnotation);
        }
    }

    public int getProgressMonitorWork() {
        return 100;
    }

    public boolean isNeeded(final SetupTaskContext context) throws Exception {
        boolean needsToBeAdded;
        block12: {
            Git git;
            block11: {
                if (StringUtil.isEmpty((String)this.getRemoteURI())) {
                    return false;
                }
                HashSet repositories = null;
                try {
                    IEclipsePreferences egitCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.egit.core");
                    IEclipsePreferences egitCoreDefaultPreferences = DefaultScope.INSTANCE.getNode("org.eclipse.egit.core");
                    this.timeout = egitCorePreferences.getInt("core_remote_connection_timeout", egitCoreDefaultPreferences.getInt("core_remote_connection_timeout", 0));
                    Class egitUIActivatorClass = CommonPlugin.loadClass((String)"org.eclipse.egit.ui", (String)"org.eclipse.egit.ui.Activator");
                    Object egitUIActivator = ReflectUtil.invokeMethod((String)"getDefault", (Object)egitUIActivatorClass);
                    this.repositoryUtil = ReflectUtil.invokeMethod((String)"getRepositoryUtil", (Object)egitUIActivator);
                    List configuredRepositories = (List)ReflectUtil.invokeMethod((String)"getConfiguredRepositories", (Object)this.repositoryUtil);
                    repositories = new HashSet(configuredRepositories);
                    if (this.timeout == 0) {
                        Object egitUIPreferenceStore = ReflectUtil.invokeMethod((String)"getPreferenceStore", (Object)egitUIActivator);
                        this.timeout = (Integer)ReflectUtil.invokeMethod((Method)ReflectUtil.getMethod((Object)egitUIPreferenceStore, (String)"getInt", (Class[])new Class[]{String.class}), (Object)egitUIPreferenceStore, (Object[])new Object[]{"remote_connection_timeout"});
                    }
                }
                catch (Throwable egitCorePreferences) {
                    // empty catch block
                }
                String location = this.getLocation();
                this.workDir = new File(location);
                if (!this.workDir.isDirectory()) {
                    return true;
                }
                this.workDirExisted = true;
                boolean bl = needsToBeAdded = repositories != null && !repositories.contains(new File(this.workDir, ".git").toString());
                if (this.workDir.list().length > 1) {
                    this.bypassCloning = true;
                    return needsToBeAdded;
                }
                context.log(NLS.bind((String)Messages.GitCloneTaskImpl_OpeningClone_message, (Object)this.workDir));
                try {
                    git = Git.open((File)this.workDir);
                    if (GitCloneTaskImpl.hasWorkTree(git) && GitCloneTaskImpl.hasReflog(git)) break block11;
                    FileUtil.rename((File)this.workDir);
                    this.workDirExisted = false;
                    return true;
                }
                catch (Throwable ex) {
                    if (!this.workDirExisted) {
                        FileUtil.delete((File)this.workDir, (IProgressMonitor)new NullProgressMonitor(){

                            public boolean isCanceled() {
                                return context.isCanceled();
                            }
                        });
                    }
                    throw new Exception(ex);
                }
            }
            Repository repository = git.getRepository();
            String checkoutBranch = this.getCheckoutBranch();
            String remoteName = this.getRemoteName();
            String remoteURI = this.getRemoteURI();
            String pushURI = this.getPushURI();
            GitCloneTaskImpl.configureRepository(context, repository, checkoutBranch, this.isRestrictToCheckoutBranch(), remoteName, remoteURI, pushURI, this.getConfigSections(), GitCloneTaskImpl.getGerritPatterns(context));
            boolean bl = this.hasCheckout = GitCloneTaskImpl.findRef(repository, "refs/heads/" + checkoutBranch) != null;
            if (this.hasCheckout) break block12;
            this.cachedGit = git;
            this.cachedRepository = repository;
            return true;
        }
        this.bypassCloning = true;
        return needsToBeAdded;
    }

    public void perform(SetupTaskContext context) throws Exception {
        try {
            String checkoutBranch = this.getCheckoutBranch();
            String remoteName = this.getRemoteName();
            String remoteURI = this.getRemoteURI();
            Set<String> gerritPatterns = GitCloneTaskImpl.getGerritPatterns(context);
            IProgressMonitor monitor = context.getProgressMonitor(true);
            monitor.beginTask(LOCATION_EDEFAULT, (this.cachedGit == null ? 51 : 0) + (!this.hasCheckout ? 3 : 0) + (this.isRecursive() ? 20 : 0));
            try {
                if (!this.bypassCloning) {
                    if (this.cachedGit == null) {
                        this.cachedGit = GitCloneTaskImpl.cloneRepository(context, this.workDir, checkoutBranch, this.isRestrictToCheckoutBranch(), remoteName, remoteURI, this.isRecursive(), this.timeout, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)50));
                        this.cachedRepository = this.cachedGit.getRepository();
                        if (!URI.createURI((String)remoteURI).isFile()) {
                            String pushURI = this.getPushURI();
                            GitCloneTaskImpl.configureRepository(context, this.cachedRepository, checkoutBranch, this.isRestrictToCheckoutBranch(), remoteName, remoteURI, pushURI, this.getConfigSections(), gerritPatterns);
                        }
                        monitor.worked(1);
                    }
                    this.workDirExisted = true;
                    if (!this.hasCheckout) {
                        Ref branchRef = GitCloneTaskImpl.findRef(this.cachedGit.getRepository(), "refs/remotes/" + remoteName + "/" + checkoutBranch);
                        Ref tagRef = GitCloneTaskImpl.findRef(this.cachedGit.getRepository(), "refs/tags/" + checkoutBranch);
                        if (branchRef == null && tagRef != null) {
                            GitCloneTaskImpl.createTag(context, this.cachedGit, checkoutBranch);
                            monitor.worked(1);
                            GitCloneTaskImpl.checkoutTag(context, this.cachedGit, checkoutBranch);
                            monitor.worked(1);
                        } else {
                            GitCloneTaskImpl.createBranch(context, this.cachedGit, checkoutBranch, remoteName);
                            monitor.worked(1);
                            GitCloneTaskImpl.checkoutBranch(context, this.cachedGit, checkoutBranch);
                            monitor.worked(1);
                        }
                        GitCloneTaskImpl.resetHard(context, this.cachedGit);
                        monitor.worked(1);
                    }
                    if (this.isRecursive()) {
                        GitCloneTaskImpl.addSubmodules(context, this.cachedGit, checkoutBranch, remoteName, gerritPatterns, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)20));
                    }
                }
                if (this.repositoryUtil != null) {
                    try {
                        Method addConfiguredRepositoryMethod = ReflectUtil.getMethod(this.repositoryUtil.getClass(), (String)"addConfiguredRepository", (Class[])new Class[]{File.class});
                        ReflectUtil.invokeMethod((Method)addConfiguredRepositoryMethod, (Object)this.repositoryUtil, (Object[])new Object[]{new File(this.workDir, ".git")});
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                monitor.done();
            }
        }
        catch (Throwable ex) {
            if (!this.workDirExisted) {
                context.setTerminating();
                if (ex instanceof OperationCanceledException) {
                    context.log(Messages.GitCloneTaskImpl_DeletingClone_message);
                }
                try {
                    FileUtil.delete((File)this.workDir, (IProgressMonitor)new NullProgressMonitor(){

                        public boolean isCanceled() {
                            return false;
                        }
                    });
                }
                catch (Exception deleteException) {
                    context.log((Throwable)deleteException);
                }
            }
            if (ex instanceof OperationCanceledException) {
                throw (OperationCanceledException)ex;
            }
            throw new Exception(ex);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.cachedRepository != null) {
            this.cachedRepository.close();
        }
    }

    private static boolean hasWorkTree(Git git) throws Exception {
        try {
            StatusCommand statusCommand = git.status();
            statusCommand.call();
            return true;
        }
        catch (NoWorkTreeException ex) {
            return false;
        }
    }

    private static boolean hasReflog(Git git) throws Exception {
        try {
            ReflogCommand reflogCommand = git.reflog();
            Collection reflog = reflogCommand.call();
            return !reflog.isEmpty();
        }
        catch (InvalidRefNameException ex) {
            return false;
        }
    }

    private static Git cloneRepository(SetupTaskContext context, File workDir, String checkoutBranch, boolean restrictToCheckoutBranch, String remoteName, String remoteURI, boolean recursive, int timeout, IProgressMonitor monitor) throws Exception {
        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_CloningRepo_message, (Object)remoteURI, (Object)workDir));
        CloneCommand command = Git.cloneRepository();
        command.setNoCheckout(true);
        command.setURI(remoteURI);
        command.setRemote(remoteName);
        command.setCloneAllBranches(!restrictToCheckoutBranch);
        command.setCloneSubmodules(recursive);
        if (restrictToCheckoutBranch) {
            command.setBranchesToClone(Collections.singleton("refs/heads/" + checkoutBranch));
        }
        command.setDirectory(workDir);
        command.setTimeout(timeout <= 0 ? 60 : timeout);
        command.setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer(monitor));
        return command.call();
    }

    private static void configureRepository(SetupTaskContext context, Repository repository, String checkoutBranch, boolean restrictToCheckoutBranch, String remoteName, String remoteURI, String pushURI, List<? extends ConfigSection> configSections, Set<String> gerritPatterns) throws Exception, IOException {
        int n;
        int n2;
        int n3;
        StoredConfig config = repository.getConfig();
        LinkedHashMap<String, Map<String, Map<String, List<String>>>> properties = new LinkedHashMap<String, Map<String, Map<String, List<String>>>>();
        for (ConfigSection configSection : configSections) {
            String sectionName = configSection.getName();
            if (StringUtil.isEmpty((String)sectionName)) continue;
            for (ConfigProperty property : configSection.getProperties()) {
                GitCloneTaskImpl.handleProperty(properties, sectionName, null, property);
            }
            for (Object subsection : configSection.getSubsections()) {
                String subsectionName = subsection.getName();
                if (subsectionName == null) continue;
                for (ConfigProperty property : subsection.getProperties()) {
                    GitCloneTaskImpl.handleProperty(properties, sectionName, subsectionName, property);
                }
            }
        }
        boolean bl = false;
        boolean hasAutoCRLFProperty = false;
        for (Map.Entry sectionEntry : properties.entrySet()) {
            String sectionName = (String)sectionEntry.getKey();
            for (Map.Entry subsectionEntry : ((Map)sectionEntry.getValue()).entrySet()) {
                String subsectionName = (String)subsectionEntry.getKey();
                for (Map.Entry propertyEntry : ((Map)subsectionEntry.getValue()).entrySet()) {
                    String key = (String)propertyEntry.getKey();
                    if ("core".equals(sectionName) && subsectionName == null && "autocrlf".equals(key)) {
                        hasAutoCRLFProperty = true;
                    }
                    List value = (List)propertyEntry.getValue();
                    String[] oldValue = config.getStringList(sectionName, subsectionName, key);
                    if (value.isEmpty()) {
                        config.unset(sectionName, subsectionName, key);
                        n4 |= oldValue.length != 0 ? 1 : 0;
                        continue;
                    }
                    config.setStringList(sectionName, subsectionName, key, value);
                    n4 |= Arrays.asList(oldValue).equals(value) ? 0 : 1;
                }
            }
        }
        if (!hasAutoCRLFProperty) {
            int n4;
            n3 = n4 | GitCloneTaskImpl.configureLineEndingConversion(context, config);
        }
        if (!gerritPatterns.isEmpty()) {
            URI uri = URI.createURI((String)remoteURI);
            String uriString = uri.toString();
            for (String gerritPattern : gerritPatterns) {
                if (!uriString.matches(gerritPattern)) continue;
                int n2 = n3 | GitCloneTaskImpl.addGerritPullRefSpec(context, config, remoteName);
                n2 = n2 | GitCloneTaskImpl.addGerritPushRefSpec(context, config, checkoutBranch, remoteName);
                break;
            }
        }
        if ((n = n2 | GitCloneTaskImpl.addPushURI(context, config, remoteName, pushURI)) != 0) {
            config.save();
        }
        if (restrictToCheckoutBranch) {
            int n6 = n | GitCloneTaskImpl.setSingleFetchRefSpec(context, config, checkoutBranch, remoteName);
        }
    }

    private static Set<String> getGerritPatterns(SetupTaskContext context) {
        HashSet<String> gerritPatterns = new HashSet<String>();
        for (Object key : context.keySet()) {
            Object value;
            if (!(key instanceof String) || !key.toString().endsWith(".gerrit.uri.pattern") || !((value = context.get(key)) instanceof String)) continue;
            gerritPatterns.add(value.toString());
        }
        return gerritPatterns;
    }

    private static boolean setSingleFetchRefSpec(SetupTaskContext context, StoredConfig config, String checkoutBranch, String remoteName) throws Exception {
        for (RemoteConfig remoteConfig : RemoteConfig.getAllRemoteConfigs((Config)config)) {
            if (!remoteName.equals(remoteConfig.getName())) continue;
            RefSpec oldRrefSpec = new RefSpec();
            oldRrefSpec = oldRrefSpec.setForceUpdate(true);
            oldRrefSpec = oldRrefSpec.setSourceDestination("refs/heads/*", "refs/remotes/" + remoteName + "/*");
            String src = "refs/heads/" + checkoutBranch;
            String dst = "refs/remotes/" + remoteName + "/" + checkoutBranch;
            RefSpec newRefSpec = new RefSpec();
            newRefSpec = newRefSpec.setForceUpdate(true);
            if (remoteConfig.addFetchRefSpec(newRefSpec = newRefSpec.setSourceDestination(src, dst)) && remoteConfig.removeFetchRefSpec(oldRrefSpec) && context.isPerforming()) {
                context.log(Messages.GitCloneTaskImpl_FetchingRefSpec_message);
            }
            remoteConfig.update((Config)config);
            return true;
        }
        return false;
    }

    private static void handleProperty(Map<String, Map<String, Map<String, List<String>>>> properties, String sectionName, String subsectionName, ConfigProperty property) {
        String key = property.getKey();
        if (!StringUtil.isEmpty((String)key)) {
            List<String> list;
            Map<String, List<String>> sectionProperties;
            Map<String, Map<String, List<String>>> subsections;
            String value = property.getValue();
            if (StringUtil.isEmpty((String)value)) {
                value = null;
            }
            if ((subsections = properties.get(sectionName)) == null) {
                subsections = new LinkedHashMap<String, Map<String, List<String>>>();
                properties.put(sectionName, subsections);
            }
            if ((sectionProperties = subsections.get(subsectionName)) == null) {
                sectionProperties = new LinkedHashMap<String, List<String>>();
                subsections.put(subsectionName, sectionProperties);
            }
            if ((list = sectionProperties.get(key)) == null) {
                list = new ArrayList<String>();
                sectionProperties.put(key, list);
            }
            if (value != null) {
                list.add(value);
            }
        }
    }

    private static boolean configureLineEndingConversion(SetupTaskContext context, StoredConfig config) throws Exception {
        OS os = context.getOS();
        if (os.isLineEndingConversionNeeded()) {
            if (context.isPerforming()) {
                context.log(NLS.bind((String)Messages.GitCloneTaskImpl_SettingConfig_message, (Object)"autocrlf"));
            }
            config.setEnum("core", null, "autocrlf", (Enum)CoreConfig.AutoCRLF.TRUE);
            return true;
        }
        return false;
    }

    private static boolean addGerritPullRefSpec(SetupTaskContext context, StoredConfig config, String remoteName) throws Exception {
        for (RemoteConfig remoteConfig : RemoteConfig.getAllRemoteConfigs((Config)config)) {
            if (!remoteName.equals(remoteConfig.getName())) continue;
            RefSpec refSpec = new RefSpec("refs/notes/*:refs/notes/*");
            if (remoteConfig.addFetchRefSpec(refSpec) && context.isPerforming()) {
                context.log(NLS.bind((String)Messages.GitCloneTaskImpl_AddingFetchRefSpec_message, (Object)refSpec));
            }
            remoteConfig.update((Config)config);
            return true;
        }
        return false;
    }

    private static boolean addGerritPushRefSpec(SetupTaskContext context, StoredConfig config, String checkoutBranch, String remoteName) throws Exception {
        for (RemoteConfig remoteConfig : RemoteConfig.getAllRemoteConfigs((Config)config)) {
            if (!remoteName.equals(remoteConfig.getName())) continue;
            RefSpec refSpec = new RefSpec("HEAD:refs/for/" + checkoutBranch);
            if (remoteConfig.addPushRefSpec(refSpec) && context.isPerforming()) {
                context.log(NLS.bind((String)Messages.GitCloneTaskImpl_AddingPushRefSpec_message, (Object)refSpec));
            }
            remoteConfig.update((Config)config);
            return true;
        }
        return false;
    }

    private static boolean addPushURI(SetupTaskContext context, StoredConfig config, String remoteName, String pushURI) throws Exception {
        boolean uriAdded = false;
        if (!StringUtil.isEmpty((String)pushURI)) {
            URIish uri = new URIish(pushURI);
            for (RemoteConfig remoteConfig : RemoteConfig.getAllRemoteConfigs((Config)config)) {
                if (!remoteName.equals(remoteConfig.getName())) continue;
                if (context.isPerforming()) {
                    context.log(NLS.bind((String)Messages.GitCloneTaskImpl_AddingPushURI_message, (Object)pushURI));
                }
                if (!(uriAdded = remoteConfig.addPushURI(uri))) break;
                remoteConfig.update((Config)config);
                break;
            }
        }
        return uriAdded;
    }

    private static void createBranch(SetupTaskContext context, Git git, String checkoutBranch, String remoteName) throws Exception {
        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_CreatingLocalBranch_message, (Object)checkoutBranch));
        CreateBranchCommand command = git.branchCreate();
        command.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM);
        command.setName(checkoutBranch);
        command.setStartPoint("refs/remotes/" + remoteName + "/" + checkoutBranch);
        command.call();
        StoredConfig config = git.getRepository().getConfig();
        config.setBoolean("branch", checkoutBranch, "rebase", true);
        config.save();
    }

    private static void createTag(SetupTaskContext context, Git git, String checkoutTag) throws Exception {
        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_CreatingLocalTab_message, (Object)checkoutTag));
        CreateBranchCommand command = git.branchCreate();
        command.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM);
        command.setName(checkoutTag);
        command.setStartPoint("refs/tags/" + checkoutTag);
        command.call();
        StoredConfig config = git.getRepository().getConfig();
        config.setBoolean("branch", checkoutTag, "rebase", true);
        config.save();
    }

    private static void checkoutTag(SetupTaskContext context, Git git, String checkoutTag) throws Exception {
        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_CheckingOutLocalBranch_message, (Object)checkoutTag));
        CheckoutCommand command = git.checkout();
        command.setName("refs/heads/" + checkoutTag);
        command.call();
    }

    private static void checkoutBranch(SetupTaskContext context, Git git, String checkoutBranch) throws Exception {
        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_CheckingOutLocalBranch_message, (Object)checkoutBranch));
        CheckoutCommand command = git.checkout();
        command.setName(checkoutBranch);
        command.call();
    }

    private static void addSubmodules(SetupTaskContext context, Git git, String checkoutBranch, String remoteName, Set<String> gerritPatterns, IProgressMonitor monitor) throws Exception {
        context.log(Messages.GitCloneTaskImpl_AddingSubmodules_message);
        git.submoduleInit().call();
        SubmoduleUpdateCommand updateCommand = git.submoduleUpdate();
        updateCommand.setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer(monitor));
        updateCommand.call();
        if (!gerritPatterns.isEmpty()) {
            GitCloneTaskImpl.submoduleConfigureGerrit(context, git, checkoutBranch, remoteName, gerritPatterns, monitor);
        }
    }

    private static void submoduleConfigureGerrit(SetupTaskContext context, Git git, String checkoutBranch, String remoteName, Set<String> gerritPatterns, IProgressMonitor monitor) throws Exception {
        Repository repo = git.getRepository();
        SubmoduleWalk generator = null;
        try {
            generator = SubmoduleWalk.forIndex((Repository)repo);
            block3: while (generator.next()) {
                String subRemoteURI = generator.getRemoteUrl();
                for (String gerritPattern : gerritPatterns) {
                    if (!subRemoteURI.matches(gerritPattern)) continue;
                    context.log(NLS.bind((String)Messages.GitCloneTaskImpl_ConfigureSubmodule_message, (Object)generator.getModuleName()));
                    Repository subRepo = generator.getRepository();
                    StoredConfig subConfig = subRepo.getConfig();
                    GitCloneTaskImpl.addGerritPullRefSpec(context, subConfig, remoteName);
                    GitCloneTaskImpl.addGerritPushRefSpec(context, subConfig, checkoutBranch, remoteName);
                    subConfig.save();
                    continue block3;
                }
            }
        }
        finally {
            if (generator != null) {
                generator.close();
            }
        }
    }

    private static void resetHard(SetupTaskContext context, Git git) throws Exception {
        context.log(Messages.GitCloneTaskImpl_ResettingHard_message);
        ResetCommand command = git.reset();
        command.setMode(ResetCommand.ResetType.HARD);
        command.call();
    }

    @Deprecated
    private static final Ref findRef(Repository repository, String name) throws IOException {
        return repository.getRefDatabase().getRef(name);
    }
}

