/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.provider.PreferenceItemItemProvider;
import org.eclipse.oomph.projectconfig.PreferenceFilter;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.Project;
import org.eclipse.oomph.projectconfig.ProjectConfigPackage;
import org.eclipse.oomph.projectconfig.provider.Messages;
import org.eclipse.oomph.projectconfig.provider.ProjectConfigEditPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceFilterItemProvider
extends ModelElementItemProvider {
    Map<Property, IWrapperItemProvider> wrappers = new HashMap<Property, IWrapperItemProvider>();

    public PreferenceFilterItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPreferenceNodePropertyDescriptor(object);
            this.addInclusionsPropertyDescriptor(object);
            this.addExclusionsPropertyDescriptor(object);
            this.addPropertiesPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPreferenceNodePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new PreferenceItemItemProvider.PreferenceItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PreferenceFilter_preferenceNode_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PreferenceFilter_preferenceNode_feature", "_UI_PreferenceFilter_type"), (EStructuralFeature)ProjectConfigPackage.Literals.PREFERENCE_FILTER__PREFERENCE_NODE, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                PreferenceNode preferenceNode;
                Project project;
                ArrayList<EObject> result = new ArrayList<EObject>();
                PreferenceFilter preferenceFilter = (PreferenceFilter)object;
                PreferenceProfile preferenceProfile = preferenceFilter.getPreferenceProfile();
                if (preferenceProfile != null && (project = preferenceProfile.getProject()) != null && (preferenceNode = project.getPreferenceNode()) != null) {
                    TreeIterator it = preferenceNode.eAllContents();
                    while (it.hasNext()) {
                        EObject eObject = (EObject)it.next();
                        if (!(eObject instanceof PreferenceNode)) continue;
                        result.add(eObject);
                    }
                }
                return result;
            }
        });
    }

    protected void addInclusionsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PreferenceFilter_inclusions_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PreferenceFilter_inclusions_feature", "_UI_PreferenceFilter_type"), (EStructuralFeature)ProjectConfigPackage.Literals.PREFERENCE_FILTER__INCLUSIONS, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addExclusionsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PreferenceFilter_exclusions_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PreferenceFilter_exclusions_feature", "_UI_PreferenceFilter_type"), (EStructuralFeature)ProjectConfigPackage.Literals.PREFERENCE_FILTER__EXCLUSIONS, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addPropertiesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PreferenceFilter_properties_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PreferenceFilter_properties_feature", "_UI_PreferenceFilter_type"), (EStructuralFeature)ProjectConfigPackage.Literals.PREFERENCE_FILTER__PROPERTIES, false, false, false, null, null, null));
    }

    public boolean hasChildren(Object object) {
        return this.hasChildren(object, false);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/PreferenceFilter"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String name;
        PreferenceNode preferenceNode;
        PreferenceFilter preferenceFilter = (PreferenceFilter)object;
        String label = preferenceFilter.getInclusions().toString();
        String exclusions = preferenceFilter.getExclusions().toString();
        if (!"".equals(exclusions)) {
            label = String.valueOf(label) + " - " + exclusions;
        }
        if (label == null) {
            label = "<unnamed>";
        }
        if ((preferenceNode = preferenceFilter.getPreferenceNode()) != null && (name = preferenceNode.getName()) != null) {
            label = String.valueOf(name) + " -> " + label;
        }
        return label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(PreferenceFilter.class)) {
            case 1: 
            case 3: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    private IWrapperItemProvider wrap(final PreferenceFilter preferenceFilter, int i, Property project) {
        Object wrapper = this.wrappers.get(project);
        if (wrapper == null) {
            wrapper = new DelegatingWrapperItemProvider(project, preferenceFilter, null, i, this.adapterFactory){

                public Object getParent(Object object) {
                    return preferenceFilter;
                }

                public Object getImage(Object object) {
                    Object image = super.getImage(object);
                    ArrayList<Object> images = new ArrayList<Object>(2);
                    images.add(image);
                    images.add(EMFEditPlugin.INSTANCE.getImage("full/ovr16/ControlledObject"));
                    image = new ComposedImage(images);
                    return image;
                }

                public boolean hasChildren(Object object) {
                    return false;
                }

                public Collection<?> getChildren(Object object) {
                    return Collections.emptyList();
                }
            };
            this.wrappers.put(project, (IWrapperItemProvider)wrapper);
        } else {
            wrapper.setIndex(i);
        }
        return wrapper;
    }

    protected Command factorRemoveCommand(EditingDomain domain, CommandParameter commandParameter) {
        if (commandParameter.getFeature() == null) {
            Collection collection = commandParameter.getCollection();
            ArrayList<Property> properties = new ArrayList<Property>();
            for (Object value : collection) {
                if (!(value instanceof Property)) continue;
                properties.add((Property)value);
            }
            if (properties.size() == collection.size()) {
                PreferenceFilter preferenceFilter = (PreferenceFilter)commandParameter.getOwner();
                Pattern exclusions = preferenceFilter.getExclusions();
                StringBuilder newExclusions = new StringBuilder();
                if (exclusions != null) {
                    newExclusions.append(exclusions);
                }
                Pattern inclusions = preferenceFilter.getInclusions();
                StringBuilder newInclusions = new StringBuilder();
                if (inclusions != null) {
                    newInclusions.append(inclusions);
                }
                for (Property property : properties) {
                    String name = property.getName();
                    int index = newInclusions.indexOf(name = name.replace(".", "\\."));
                    if (index != -1) {
                        boolean matched = true;
                        int start = index;
                        int end = start + name.length();
                        if (start != 0) {
                            if (newInclusions.charAt(start - 1) == '|') {
                                --start;
                            } else {
                                matched = false;
                            }
                        }
                        if (matched && end != newInclusions.length()) {
                            if (newInclusions.charAt(end) == '|') {
                                ++end;
                            } else {
                                matched = false;
                            }
                        }
                        if (matched) {
                            newInclusions.delete(start, end);
                            continue;
                        }
                    }
                    if (newExclusions.length() != 0) {
                        newExclusions.append("|");
                    }
                    newExclusions.append(name);
                }
                CompoundCommand command = new CompoundCommand(Messages.PreferenceFilterItemProvider_Update_command);
                command.append(SetCommand.create((EditingDomain)domain, (Object)preferenceFilter, (Object)ProjectConfigPackage.Literals.PREFERENCE_FILTER__INCLUSIONS, (Object)Pattern.compile(newInclusions.toString())));
                command.append(SetCommand.create((EditingDomain)domain, (Object)preferenceFilter, (Object)ProjectConfigPackage.Literals.PREFERENCE_FILTER__EXCLUSIONS, (Object)Pattern.compile(newExclusions.toString())));
                return command;
            }
        }
        return super.factorRemoveCommand(domain, commandParameter);
    }

    public Collection<?> getChildren(Object object) {
        ArrayList<IWrapperItemProvider> result = new ArrayList<IWrapperItemProvider>();
        PreferenceFilter preferenceFilter = (PreferenceFilter)object;
        for (Property property : preferenceFilter.getProperties()) {
            result.add(this.wrap(preferenceFilter, -1, property));
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return ProjectConfigEditPlugin.INSTANCE;
    }
}

