/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof.describer;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.mat.hprof.describer.Version;

public class HprofContentDescriber
implements IContentDescriber {
    private static final QualifiedName[] QUALIFIED_NAMES = new QualifiedName[]{new QualifiedName("java-heap-dump", "hprof")};

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        return HprofContentDescriber.readVersion(contents) != null ? 2 : 0;
    }

    public QualifiedName[] getSupportedOptions() {
        return QUALIFIED_NAMES;
    }

    static Version readVersion(InputStream in) throws IOException {
        StringBuilder version = new StringBuilder();
        for (int bytesRead = 0; bytesRead < 20; ++bytesRead) {
            byte b = (byte)in.read();
            if (b != 0) {
                version.append((char)b);
                continue;
            }
            Version answer = Version.byLabel(version.toString());
            if (answer == null) {
                return null;
            }
            if (answer == Version.JDK12BETA3) {
                return null;
            }
            return answer;
        }
        return null;
    }
}

