/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ftask.tasks;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.domain.RuntimePlatformResourceSet;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.pattern.BundleAccessor;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.execution.ExecutionContext;
import org.osgi.framework.Bundle;

public abstract class AbstractPatternTask
implements ITaskProduction {
    protected final PatternHelper helper = PatternHelper.createCollector();

    public void preExecute(ITaskProductionContext context, IProgressMonitor monitor_p) throws InvocationException {
    }

    public void doExecute(ITaskProductionContext context, IProgressMonitor monitor_p) throws InvocationException {
    }

    public void postExecute(ITaskProductionContext context, IProgressMonitor monitor_p) throws InvocationException {
        this.helper.clear();
    }

    protected void writeContext(ITaskProductionContext context, PatternContext ctx) throws InvocationException {
        for (Contract contract : context.getOutputValueKeys()) {
            context.setOutputValue((Object)contract.getName(), ctx.getValue(contract.getName()));
        }
    }

    protected void readContext(ITaskProductionContext context, PatternContext ctx) throws InvocationException {
        for (Object object : context.getInputValueKeys()) {
            Contract contract = (Contract)object;
            String name = contract.getName();
            if ("domain".equals(name)) {
                Domain domain = (Domain)context.getInputValue((Object)name, contract.getType().getType());
                if (domain == null) continue;
                ctx.setValue("domain", (Object)domain.getContent());
                continue;
            }
            ctx.setValue(name, context.getInputValue((Object)name, contract.getType().getType()));
        }
        ctx.setValue("internal.pattern.resourceset", (Object)new RuntimePlatformResourceSet());
    }

    protected PatternContext createPatternContext(final ITaskProductionContext prodCtx) {
        return new ExecutionContext(new BundleAccessor(){

            public Bundle getBundle(String id) throws PatternException {
                try {
                    return prodCtx.getBundle(id);
                }
                catch (InvocationException e) {
                    throw new PatternException((Throwable)e);
                }
            }
        });
    }
}

