/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import java.util.ArrayList;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.FlowLinkUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;

public class DeleteLinkCommand
extends AutoUndoCommand {
    private Link link;
    private Flow flow;

    public DeleteLinkCommand(Link link) {
        super(IBPELUIConstants.CMD_DELETE_LINK, new ArrayList<Object>());
        this.link = link;
        EObject cont = link.eContainer().eContainer();
        this.flow = (Flow)cont;
        this.addModelRoot(this.flow);
    }

    @Override
    public boolean canDoExecute() {
        if (this.link == null || this.flow == null) {
            return false;
        }
        return FlowLinkUtil.getFlowLinks(this.flow).contains(this.link);
    }

    @Override
    public void doExecute() {
        int i;
        IMarkerHolder markerHolder = BPELUtil.adapt((Object)this.link, IMarkerHolder.class);
        if (markerHolder != null) {
            IMarker[] markers = markerHolder.getMarkers(this.link);
            i = 0;
            while (i < markers.length) {
                try {
                    markers[i].delete();
                }
                catch (CoreException e) {
                    BPELUIPlugin.log(e);
                }
                ++i;
            }
        }
        Object[] source = this.link.getSources().toArray();
        i = 0;
        while (i < source.length) {
            if (source[i] != null) {
                FlowLinkUtil.removeActivitySource((Source)source[i]);
            }
            ++i;
        }
        Object[] target = this.link.getTargets().toArray();
        int i2 = 0;
        while (i2 < target.length) {
            if (target[i2] != null) {
                FlowLinkUtil.removeActivityTarget((Target)target[i2]);
            }
            ++i2;
        }
        if (this.flow != null) {
            FlowLinkUtil.removeFlowLink(this.flow, this.link);
        }
    }
}

