/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.actions;

import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Sequence;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.adapters.INamedElement;
import org.eclipse.bpel.ui.editparts.CollapsableEditPart;
import org.eclipse.bpel.ui.editparts.policies.BPELDirectEditPolicy;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.NameDialog;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class RenameAction
extends SelectionAction {
    private Request request = new DirectEditRequest();
    private BPELEditor editor;

    public RenameAction(IWorkbenchPart editor) {
        super(editor);
        this.editor = (BPELEditor)editor;
    }

    protected void init() {
        super.init();
        this.setText(Messages.RenameAction_Rename_0);
        this.setToolTipText(Messages.RenameAction_Rename_1);
        this.setId(ActionFactory.RENAME.getId());
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object o = this.getSelectedObjects().get(0);
        EditPart part = (EditPart)this.editor.getGraphicalViewer().getEditPartRegistry().get(o);
        if (part == null) {
            return false;
        }
        return part.understandsRequest(this.request);
    }

    public void run() {
        Object o = this.getSelectedObjects().get(0);
        GraphicalEditPart part = (GraphicalEditPart)this.editor.getGraphicalViewer().getEditPartRegistry().get(o);
        if (this.shouldShowDialog(o)) {
            boolean canSetName;
            Object model = part.getModel();
            INamedElement namedElement = BPELUtil.adapt(model, INamedElement.class);
            ILabeledElement labeledElement = BPELUtil.adapt(model, ILabeledElement.class);
            boolean bl = canSetName = namedElement != null;
            if (labeledElement != null && canSetName) {
                String name = labeledElement.getLabel(model);
                NameDialog nameDialog = new NameDialog(part.getViewer().getControl().getShell(), Messages.BPELEditPart_Rename_2, Messages.BPELEditPart_Enter_a_new_name_3, name, null);
                if (nameDialog.open() == 0) {
                    Command cmd = BPELDirectEditPolicy.getFinalizeCommand(model, nameDialog.getValue());
                    part.getViewer().getEditDomain().getCommandStack().execute(cmd);
                }
            }
            return;
        }
        part.performRequest(this.request);
    }

    protected boolean shouldShowDialog(Object model) {
        if (model instanceof Sequence) {
            return false;
        }
        if (model instanceof Process) {
            return true;
        }
        EditPart part = (EditPart)this.editor.getGraphicalViewer().getEditPartRegistry().get(model);
        if (part instanceof CollapsableEditPart) {
            return !((CollapsableEditPart)part).isCollapsed();
        }
        return false;
    }
}

