/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.query.parser.sparql.ast.Node;
import org.eclipse.rdf4j.query.parser.sparql.ast.SyntaxTreeBuilder;
import org.eclipse.rdf4j.query.parser.sparql.ast.SyntaxTreeBuilderTreeConstants;
import org.eclipse.rdf4j.query.parser.sparql.ast.SyntaxTreeBuilderVisitor;
import org.eclipse.rdf4j.query.parser.sparql.ast.VisitorException;

public class SimpleNode
implements Node {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Object value;
    protected SyntaxTreeBuilder parser;
    private boolean isScopeChange;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(SyntaxTreeBuilder p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object value) {
        this.value = value;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    @Override
    public Object jjtAccept(SyntaxTreeBuilderVisitor visitor, Object data) throws VisitorException {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(SyntaxTreeBuilderVisitor visitor, Object data) throws VisitorException {
        if (this.children != null) {
            for (Node childNode : this.children) {
                data = childNode.jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString() {
        return SyntaxTreeBuilderTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + String.valueOf(this);
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    public <T extends Node> T jjtGetChild(Class<T> type) {
        if (this.children != null) {
            for (Node n : this.children) {
                if (!type.isInstance(n)) continue;
                return (T)n;
            }
        }
        return null;
    }

    public <T extends Node> List<T> jjtGetChildren(Class<T> type) {
        if (this.children == null) {
            return List.of();
        }
        ArrayList<Node> result = new ArrayList<Node>(this.children.length);
        for (Node n : this.children) {
            if (!type.isInstance(n)) continue;
            result.add(n);
        }
        return result;
    }

    public Node[] jjtGetChildren() {
        return this.children;
    }

    public void jjtReplaceWith(Node newNode) {
        if (this.parent != null) {
            this.parent.jjtReplaceChild(this, newNode);
        }
        if (this.children != null) {
            for (Node childNode : this.children) {
                childNode.jjtSetParent(newNode);
            }
        }
    }

    @Override
    public void jjtReplaceChild(Node oldNode, Node newNode) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] != oldNode) continue;
                this.children[i] = newNode;
            }
        }
    }

    @Override
    public void jjtAppendChild(Node n) {
        this.jjtAddChild(n, this.children == null ? 0 : this.children.length);
    }

    public boolean isScopeChange() {
        return this.isScopeChange;
    }

    public void setScopeChange(boolean isScopeChange) {
        this.isScopeChange = isScopeChange;
    }
}

