/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializerObjectArray;

public class SerializerJava
extends GroupSerializerObjectArray {
    protected final ClassLoader classLoader;

    public SerializerJava(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public SerializerJava() {
        this(Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void serialize(DataOutput2 out, Object value) throws IOException {
        ObjectOutputStream out2 = new ObjectOutputStream(out);
        out2.writeObject(value);
        out2.flush();
    }

    @Override
    public Object deserialize(DataInput2 in, int available) throws IOException {
        try {
            ObjectInputStreamWithLoader in2 = new ObjectInputStreamWithLoader(new DataInput2.DataInputToStream(in));
            return in2.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object[] valueArrayDeserialize(DataInput2 in, int size) throws IOException {
        try {
            ObjectInputStreamWithLoader in2 = new ObjectInputStreamWithLoader(new DataInput2.DataInputToStream(in));
            Object ret = in2.readObject();
            return (Object[])ret;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        ObjectOutputStream out2 = new ObjectOutputStream(out);
        out2.writeObject(vals);
        out2.flush();
    }

    class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        public ObjectInputStreamWithLoader(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                return Class.forName(name, false, SerializerJava.this.classLoader);
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }
    }
}

