/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.eclipse.rdf4j.spin.ConstraintViolation;
import org.eclipse.rdf4j.spin.ConstraintViolationLevel;

public class ConstraintViolationRDFHandler
extends AbstractRDFHandler {
    private boolean hasStatements;
    private String label;
    private String root;
    private String path;
    private String value;
    private ConstraintViolationLevel level;
    private ConstraintViolation violation;

    public ConstraintViolation getConstraintViolation() {
        return this.violation;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.hasStatements = false;
        this.label = null;
        this.root = null;
        this.path = null;
        this.value = null;
        this.level = ConstraintViolationLevel.ERROR;
        this.violation = null;
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.hasStatements = true;
        IRI pred = st.getPredicate();
        if (RDFS.LABEL.equals(pred)) {
            Value labelValue = st.getObject();
            this.label = labelValue instanceof Literal ? labelValue.stringValue() : null;
        } else if (SPIN.VIOLATION_ROOT_PROPERTY.equals(pred)) {
            Value rootValue = st.getObject();
            this.root = rootValue instanceof Resource ? rootValue.stringValue() : null;
        } else if (SPIN.VIOLATION_PATH_PROPERTY.equals(pred)) {
            Value pathValue = st.getObject();
            this.path = pathValue != null ? pathValue.stringValue() : null;
        } else if (SPIN.VIOLATION_VALUE_PROPERTY.equals(pred)) {
            Value valueValue = st.getObject();
            this.value = valueValue != null ? valueValue.stringValue() : null;
        } else if (SPIN.VIOLATION_LEVEL_PROPERTY.equals(pred)) {
            Value levelValue = st.getObject();
            if (levelValue instanceof IRI) {
                this.level = ConstraintViolationLevel.valueOf((IRI)levelValue);
            }
            if (this.level == null) {
                throw new RDFHandlerException("Invalid value " + levelValue + " for " + SPIN.VIOLATION_LEVEL_PROPERTY + ": " + st.getSubject());
            }
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        if (this.hasStatements) {
            this.violation = new ConstraintViolation(this.label, this.root, this.path, this.value, this.level);
        }
    }
}

