/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.validators;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.core.builder.IQ7ProblemReporter;
import org.eclipse.rcptt.core.builder.IQ7Validator;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;

public class VerificationReferenceValidator
implements IQ7Validator {
    @Override
    public void validate(IQ7NamedElement element, IQ7ProblemReporter reporter, IProgressMonitor monitor) {
        block15: {
            try {
                String[] verifications;
                IQ7Project project = element.getQ7Project();
                IQ7ProjectMetadata md = element.getQ7Project().getMetadata();
                List<String> defaultVerifications = null;
                if (md != null && md.exists() && (verifications = md.getVerifications()) != null) {
                    defaultVerifications = Arrays.asList(verifications);
                }
                if (element instanceof ITestCase) {
                    try {
                        verifications = Q7SearchCore.findVerificationsByDocument((IQ7Element)element);
                        if (verifications == null) {
                            verifications = ((ITestCase)element).getVerifications();
                        }
                        if (verifications != null) {
                            String[] stringArray = verifications;
                            int n = verifications.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String vid = stringArray[n2];
                                this.reportProjectVerificationUsed(element, reporter, defaultVerifications, vid);
                                List verification = project.find(IVerification.class, vid);
                                if (verification.size() == 0) {
                                    this.reportUnresolved(element, reporter, vid);
                                }
                                ++n2;
                            }
                        }
                        break block15;
                    }
                    catch (ModelException e) {
                        RcpttPlugin.log((Throwable)e);
                    }
                    break block15;
                }
                if (element instanceof IQ7ProjectMetadata) {
                    verifications = Q7SearchCore.findVerificationsByDocument((IQ7Element)element);
                    if (verifications == null) {
                        verifications = ((IQ7ProjectMetadata)element).getVerifications();
                    }
                    if (verifications != null) {
                        String[] stringArray = verifications;
                        int n = verifications.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String vid = stringArray[n3];
                            List verification = project.find(IVerification.class, vid);
                            if (verification.size() == 0) {
                                this.reportUnresolved(element, reporter, vid);
                            }
                            ++n3;
                        }
                    }
                }
            }
            catch (Throwable e) {
                TeslaCore.log((Throwable)e);
            }
        }
    }

    private void reportProjectVerificationUsed(IQ7NamedElement element, IQ7ProblemReporter reporter, List<String> defaultVerifications, String vid) {
        if (defaultVerifications != null && defaultVerifications.contains(vid)) {
            String name = vid;
            try {
                List located = element.getQ7Project().find(IVerification.class, vid);
                if (located != null && located.size() == 1) {
                    name = ((IVerification)located.get(0)).getElementName();
                }
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)e);
            }
            reporter.reportProblem((IFile)element.getResource(), IQ7ProblemReporter.ProblemType.Warning, "Referenced verification \"" + name + "\" is included as default verification for project: " + element.getQ7Project().getName() + " and will be ignored.", 0, 0, 0, 0);
        }
    }

    private void reportUnresolved(IQ7NamedElement element, IQ7ProblemReporter reporter, String vid) {
        reporter.reportProblem((IFile)element.getResource(), IQ7ProblemReporter.ProblemType.Error, "Unresolved verification:" + vid, 0, 0, 0, 0);
    }

    @Override
    public void reconcile(IQ7NamedElement content, String eclCode, IQ7ProblemReporter reporter, IProgressMonitor nullProgressMonitor) {
    }
}

