/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.base.diagnostic.TroubleHasException;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.ButtonConfig;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.CopyToClipboard;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.FirstSelected;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.NotificationDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.StatusFromException;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.TroublesViewer;
import org.eclipse.passage.lic.internal.jface.i18n.DiagnosticDialogMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public final class DiagnosticDialog
extends NotificationDialog {
    private final Diagnostic diagnostic;
    private TroublesViewer troubles;
    private ButtonConfig error;

    public DiagnosticDialog(Shell shell, Diagnostic diagnostic) {
        super(shell);
        this.diagnostic = diagnostic;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DiagnosticDialogMessages.DiagnosticDialog_title);
        shell.setImage(DiagnosticDialog.getDefaultImage());
        shell.setSize(1250, 500);
    }

    @Override
    protected void initButtons() {
        this.error = new ButtonConfig(1, this::viewError, DiagnosticDialogMessages.DiagnosticDialog_action_view_failure, DiagnosticDialogMessages.DiagnosticDialog_action_view_failure_tooltip, "");
        this.error.reside(this.buttons);
        new ButtonConfig(2, new CopyToClipboard(() -> ((DiagnosticDialog)this).getShell(), new Supplier[]{new DiagnosticExplained(this.diagnostic)}), DiagnosticDialogMessages.DiagnosticDialog_action_copy, DiagnosticDialogMessages.DiagnosticDialog_action_copy_tooltip, "").reside(this.buttons);
    }

    @Override
    protected void buildUI(Composite parent) {
        this.troubles = new TroublesViewer(this.getShell(), this.diagnostic);
        this.troubles.installControl(parent);
        this.viewer = this.troubles.viewer();
    }

    @Override
    protected void inplaceData() {
        this.troubles.installInput();
    }

    @Override
    protected void updateButtonsEnablement() {
        this.getButton(this.error.id()).setEnabled(new TroubleHasException().test(this.selectedTrouble()));
    }

    @Override
    protected void initMessage() {
        this.setMessage(DiagnosticDialogMessages.DiagnosticDialog_description);
    }

    private void viewError() {
        Optional<Trouble> trouble = this.selectedTrouble();
        if (!trouble.isPresent()) {
            return;
        }
        if (!new TroubleHasException().test(trouble)) {
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)DiagnosticDialogMessages.DiagnosticDialog_error_title, (String)trouble.get().details(), (IStatus)new StatusFromException((Throwable)trouble.get().exception().get()).get());
    }

    private Optional<Trouble> selectedTrouble() {
        return new FirstSelected<Trouble>(this.viewer.getSelection(), Trouble.class).get();
    }
}

