/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.ButtonConfig;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

abstract class NotificationDialog
extends TitleAreaDialog {
    protected final Map<Integer, ButtonConfig> buttons = new TreeMap<Integer, ButtonConfig>();
    protected TableViewer viewer;

    public NotificationDialog(Shell shell) {
        super(shell);
    }

    protected final Control createDialogArea(Composite parent) {
        Composite owner = this.owner(parent);
        this.buildUI(owner);
        this.installBehaviour();
        this.inplaceData();
        this.initMessage();
        return owner;
    }

    protected final void buttonPressed(int id) {
        Optional.ofNullable(this.buttons.get(id)).map(button -> button.action()).orElse(() -> ((NotificationDialog)this).okPressed()).run();
    }

    protected final void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        this.initButtons();
        this.buttons.keySet().forEach(id -> this.createButton(parent, this.buttons.get(id)));
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        this.updateButtonsEnablement();
    }

    protected final boolean isResizable() {
        return true;
    }

    private void createButton(Composite parent, ButtonConfig config) {
        Button button = this.createButton(parent, config.id(), config.name(), false);
        button.setToolTipText(config.tooltip());
        button.setImage(LicensingImages.getImage(config.image()));
    }

    private Composite owner(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        return composite;
    }

    private void installBehaviour() {
        this.viewer.addSelectionChangedListener(event -> this.updateButtonsEnablement());
    }

    protected abstract void buildUI(Composite var1);

    protected abstract void initButtons();

    protected abstract void inplaceData();

    protected abstract void updateButtonsEnablement();

    protected abstract void initMessage();
}

