/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.nodejs;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.UUID;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.cf.ds.IDeploymentPackager;
import org.eclipse.orion.server.cf.nodejs.CFLauncherPackager;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.core.IOUtilities;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CFLauncherDeploymentPackager
implements IDeploymentPackager {
    protected static final String CF_LAUNCHER = "cf-launcher";
    protected static final String CF_LAUNCHER_VERSION = "0.0.x";

    @Override
    public String getId() {
        return this.getClass().getCanonicalName();
    }

    protected void setupDependencies(JSONObject packageJSON) throws JSONException {
        String dependencyString;
        JSONArray dependencyArray;
        if (!packageJSON.has("dependencies")) {
            packageJSON.put("dependencies", (Object)new JSONObject());
            return;
        }
        Object dependencies = packageJSON.get("dependencies");
        if (dependencies instanceof JSONArray && (dependencyArray = (JSONArray)dependencies).length() == 0) {
            packageJSON.remove("dependencies");
            packageJSON.put("dependencies", (Object)new JSONObject());
            return;
        }
        if (dependencies instanceof String && ((dependencyString = (String)dependencies) == null || dependencyString.isEmpty())) {
            packageJSON.remove("dependencies");
            packageJSON.put("dependencies", (Object)new JSONObject());
            return;
        }
    }

    @Override
    public File getDeploymentPackage(App application, IFileStore contentLocation, String command) throws IOException, CoreException {
        IFileStore packageStore = contentLocation.getChild("package.json");
        if (!packageStore.fetchInfo().exists()) {
            return null;
        }
        InputStream is = null;
        JSONObject packageJSON = null;
        try {
            try {
                is = packageStore.openInputStream(0, null);
                packageJSON = new JSONObject(new JSONTokener((Reader)new InputStreamReader(is)));
                if (!packageJSON.has("dependencies")) {
                    packageJSON.put("dependencies", (Object)new JSONObject());
                }
                this.setupDependencies(packageJSON);
                JSONObject dependencies = packageJSON.getJSONObject("dependencies");
                if (!dependencies.has(CF_LAUNCHER)) {
                    dependencies.put(CF_LAUNCHER, (Object)CF_LAUNCHER_VERSION);
                }
            }
            catch (JSONException jSONException) {
                IOUtilities.safeClose(is);
                return null;
            }
        }
        catch (Throwable throwable) {
            IOUtilities.safeClose(is);
            throw throwable;
        }
        IOUtilities.safeClose((Closeable)is);
        File tmp = null;
        ZipOutputStream zos = null;
        try {
            String randomName = UUID.randomUUID().toString();
            tmp = File.createTempFile(randomName, ".zip");
            zos = new ZipOutputStream(new FileOutputStream(tmp));
            CFLauncherPackager packager = new CFLauncherPackager(contentLocation, packageJSON);
            packager.writeZip(contentLocation, zos);
            File file = tmp;
            return file;
        }
        catch (Exception exception) {
            if (tmp != null) {
                tmp.delete();
            }
            return null;
        }
        finally {
            if (zos != null) {
                zos.close();
            }
        }
    }
}

