/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSFontPanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;
    boolean selected;
    int fontID;
    int fontSize;
    boolean effectsVisible = true;

    public FontDialog(Shell parent) {
        this(parent, 65536);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, FontDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    void changeFont(int id2, int sel, int arg0) {
        this.selected = true;
    }

    public boolean getEffectsVisible() {
        return this.effectsVisible;
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        NSFont nsFont;
        Display display = this.parent != null ? this.parent.display : Display.getCurrent();
        NSFontPanel panel = NSFontPanel.sharedFontPanel();
        panel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        boolean create = this.fontData != null;
        Font font = create ? new Font((Device)display, this.fontData) : display.getSystemFont();
        panel.setPanelFont(font.handle, false);
        SWTPanelDelegate delegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
        int jniRef = OS.NewGlobalRef(this);
        if (jniRef == 0) {
            this.error(2);
        }
        OS.object_setInstanceVariable(delegate.id, Display.SWT_OBJECT, jniRef);
        panel.setDelegate(delegate);
        this.fontData = null;
        this.selected = false;
        panel.orderFront(null);
        display.setModalDialog(this);
        NSApplication.sharedApplication().runModalForWindow(panel);
        display.setModalDialog(null);
        if (this.selected && (nsFont = panel.panelConvertFont(font.handle)) != null) {
            this.fontData = Font.cocoa_new(display, nsFont).getFontData()[0];
        }
        panel.setDelegate(null);
        delegate.release();
        OS.DeleteGlobalRef(jniRef);
        if (create) {
            font.dispose();
        }
        return this.fontData;
    }

    void setColor_forAttribute(int id2, int sel, int colorArg, int attribute) {
        if (attribute != 0 && NSString.stringWith("NSColor").isEqualToString(new NSString(attribute))) {
            if (colorArg != 0) {
                NSColor color = new NSColor(colorArg);
                Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
                float[] handle = display.getNSColorRGB(color);
                this.rgb = new RGB((int)(handle[0] * 255.0f), (int)(handle[1] * 255.0f), (int)(handle[2] * 255.0f));
            } else {
                this.rgb = null;
            }
        }
    }

    public void setEffectsVisible(boolean visible) {
        this.effectsVisible = visible;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    int validModesForFontPanel(int id2, int sel, int arg0) {
        return this.effectsVisible ? -1 : -1048321;
    }

    void windowWillClose(int id2, int sel, int sender) {
        NSApplication.sharedApplication().stop(null);
    }
}

