/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.useradmin;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.orion.internal.server.servlets.useradmin.UserEmailUtil;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONException;
import org.json.JSONObject;

public class EmailConfirmationServlet
extends OrionServlet {
    private static final long serialVersionUID = 2029138177545673411L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        String[] userPathInfoParts = req.getPathInfo().split("\\/", 2);
        String userId = userPathInfoParts[1];
        UserInfo userInfo = null;
        try {
            userInfo = OrionConfiguration.getMetaStore().readUserByProperty("UserName", userId, false, false);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            resp.sendError(404, "User " + userId + " not found.");
            return;
        }
        if (userInfo == null) {
            resp.sendError(404, "User " + userId + " not found.");
            return;
        }
        if (req.getParameter("PasswordResetId") != null) {
            this.resetPassword(userInfo, req, resp);
        } else {
            this.confirmEmail(userInfo, req, resp);
        }
    }

    private void resetPassword(UserInfo userInfo, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (userInfo.getProperty("PasswordResetId") == null || "".equals(userInfo.getProperty("PasswordResetId"))) {
            resp.sendError(400, "You have not requested to reset your password or this password reset request was already completed");
            return;
        }
        if (!userInfo.getProperty("PasswordResetId").equals(req.getParameter("PasswordResetId"))) {
            resp.sendError(400, "This password reset request is out of date");
            return;
        }
        String newPass = this.getRandomPassword();
        userInfo.setProperty("Password", newPass);
        userInfo.setProperty("PasswordResetId", null);
        try {
            UserEmailUtil.getUtil().setPasswordResetEmail(userInfo);
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
            resp.sendError(500, "Your password could not be changed, because confirmation email could not be sent. To reset your password contact your administrator.");
            return;
        }
        try {
            OrionConfiguration.getMetaStore().updateUser(userInfo);
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
            resp.sendError(500, "Your password could not be changed. To reset your password contact your administrator.");
            return;
        }
        resp.setContentType("text/html;charset=UTF-8");
        resp.getWriter().write("<html><body><p>Your password has been successfully reset. Your new password has been sent to the email address associated with your account.</p></body></html>");
    }

    private void confirmEmail(UserInfo userInfo, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (userInfo.getProperty("EmailConfirmationId") == null) {
            resp.setContentType("text/html;charset=UTF-8");
            resp.getWriter().write("<html><body><p>Your email address has already been confirmed. Thank you!</p></body></html>");
            return;
        }
        if (req.getParameter("EmailConfirmationId") == null || !req.getParameter("EmailConfirmationId").equals(userInfo.getProperty("EmailConfirmationId"))) {
            resp.sendError(400, "Email could not be confirmed.");
            return;
        }
        try {
            userInfo.setProperty("EmailConfirmationId", null);
            userInfo.setProperty("Blocked", null);
            OrionConfiguration.getMetaStore().updateUser(userInfo);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            resp.sendError(500, e.getMessage());
            return;
        }
        resp.setContentType("text/html;charset=UTF-8");
        StringBuffer host = new StringBuffer();
        String scheme = req.getScheme();
        host.append(scheme);
        host.append(":////");
        String servername = req.getServerName();
        host.append(servername);
        host.append(":");
        int port = req.getServerPort();
        host.append(port);
        resp.getWriter().write("<html><body><p>Your email address has been confirmed. Thank you! <a href=\"" + host + "\">Click here</a> to continue and login to your account.</p></body></html>");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserInfo userInfo;
        String[] userPathInfoParts;
        this.traceRequest(req);
        String[] stringArray = userPathInfoParts = req.getPathInfo() == null ? new String[]{} : req.getPathInfo().split("\\/", 2);
        if (userPathInfoParts.length > 1 && userPathInfoParts[1] != null && "cansendemails".equalsIgnoreCase(userPathInfoParts[1])) {
            JSONObject jsonResp = new JSONObject();
            try {
                jsonResp.put("EmailConfigured", UserEmailUtil.getUtil().isEmailConfigured());
                EmailConfirmationServlet.writeJSONResponse(req, resp, jsonResp);
            }
            catch (JSONException e) {
                resp.sendError(500, e.getMessage());
            }
            return;
        }
        String userEmail = null;
        String userName = null;
        try {
            JSONObject json = OrionServlet.readJSONRequest(req);
            if (json.has("Email")) {
                userEmail = json.getString("Email");
            }
            if (json.has("UserName")) {
                userName = json.getString("UserName");
            }
        }
        catch (JSONException e) {
            this.getStatusHandler().handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "Could not parse json request", (Throwable)e));
            return;
        }
        ArrayList<UserInfo> users = new ArrayList<UserInfo>();
        if (userName != null && userName.trim().length() > 0) {
            userInfo = null;
            try {
                userInfo = OrionConfiguration.getMetaStore().readUserByProperty("UserName", userName.trim(), false, false);
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
                resp.sendError(500, e.getMessage());
                return;
            }
            if (userInfo == null) {
                resp.sendError(404, "User " + userName + " not found.");
                return;
            }
            if (userEmail != null && userEmail.trim().length() > 0) {
                if (!this.isEmailConfirmed(userInfo)) {
                    resp.sendError(400, "User " + userName + " email has not been yet confirmed." + " Please follow the instructions from the confirmation email in your inbox and then request a password reset again.");
                    return;
                }
                if (!userEmail.equals(userInfo.getProperty("Email"))) {
                    resp.sendError(404, "User " + userName + " with email " + userEmail + " does not exist.");
                    return;
                }
            }
            users.add(userInfo);
        } else if (userEmail != null && userEmail.trim().length() > 0) {
            userInfo = null;
            try {
                userInfo = OrionConfiguration.getMetaStore().readUserByProperty("Email", userEmail.trim().toLowerCase(), false, false);
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
                resp.sendError(500, e.getMessage());
                return;
            }
            if (userInfo != null && this.isEmailConfirmed(userInfo)) {
                users.add(userInfo);
            }
            if (users.size() == 0) {
                if (userInfo == null) {
                    resp.sendError(404, "User with email " + userEmail + " not found.");
                } else {
                    resp.sendError(400, "Email " + userName + " has not been yet confirmed." + " Please follow the instructions from the confirmation email in your inbox and then request a password reset again.");
                }
                return;
            }
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.orion.server.core", 0, null, null);
        req.getRequestURI();
        URI baseURI = URI.create(req.getRequestURL().toString());
        for (UserInfo userInfo2 : users) {
            multiStatus.add(this.sendPasswordResetConfirmation(userInfo2, baseURI));
        }
        if (!multiStatus.isOK()) {
            int i = 0;
            while (i < multiStatus.getChildren().length) {
                IStatus status = multiStatus.getChildren()[i];
                if (!status.isOK()) {
                    this.getStatusHandler().handleRequest(req, resp, status);
                    return;
                }
                ++i;
            }
        }
        this.getStatusHandler().handleRequest(req, resp, (IStatus)new ServerStatus(1, 200, "Confirmation email has been sent to " + userEmail, null));
    }

    private IStatus sendPasswordResetConfirmation(UserInfo userInfo, URI baseUri) {
        if (userInfo.getProperty("Email") == null || userInfo.getProperty("Email").length() == 0) {
            return new ServerStatus(4, 400, "User " + userInfo.getUniqueId() + " doesn't have its email set. Contact administrator to reset your password.", null);
        }
        if (!this.isEmailConfirmed(userInfo)) {
            return new ServerStatus(4, 400, "Your email has not been yet confirmed. Please follow the instructions from the confirmation email in your inbox and then request a password reset again.", null);
        }
        try {
            userInfo.setProperty("PasswordResetId", EmailConfirmationServlet.getUniqueEmailConfirmationId());
            OrionConfiguration.getMetaStore().updateUser(userInfo);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return new ServerStatus(4, 500, e.getMessage(), (Throwable)e);
        }
        try {
            UserEmailUtil.getUtil().sendResetPasswordConfirmation(baseUri, userInfo);
            return new ServerStatus(1, 200, "Confirmation email has been sent.", null);
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
            return new ServerStatus(4, 400, "Could not send confirmation email.", null);
        }
    }

    private String getRandomPassword() {
        return this.getRandomString(5, 25);
    }

    private String getRandomString(int lo, int hi) {
        int n = this.getRandomNumber(lo, hi);
        byte[] b = new byte[n];
        int i = 0;
        while (i < n) {
            b[i] = (byte)this.getRandomNumber(49, 90);
            ++i;
        }
        return new String(b);
    }

    private int getRandomNumber(int lo, int hi) {
        Random rn = new Random();
        int n = hi - lo + 1;
        int i = rn.nextInt(n);
        if (i < 0) {
            i = -i;
        }
        return lo + i;
    }

    private boolean isEmailConfirmed(UserInfo userInfo) {
        String email = userInfo.getProperty("Email");
        return email != null && email.length() > 0 ? userInfo.getProperty("EmailConfirmationId") == null : false;
    }

    private static String getUniqueEmailConfirmationId() {
        return String.valueOf(System.currentTimeMillis()) + "-" + Math.random();
    }
}

