/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.TimerTask;

class DetachedTransactionReaper {
    static final int DEFAULT_TIMEOUT = 0;
    List txns = null;
    TimerTask mytimer = null;
    TransactionList translist = null;
    private static MQTimer timer = Globals.getTimer();
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private static final int timeoutsec = Globals.getConfig().getIntProperty("imq.transaction.detachedTimeout", 0);
    boolean destroyed = false;

    DetachedTransactionReaper(TransactionList tl) {
        this.translist = tl;
        this.txns = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDetachedTID(TransactionUID tid) {
        if (TransactionList.DEBUG_CLUSTER_TXN) {
            this.logger.log(8, "addDetachedTID: " + String.valueOf(tid));
        }
        if (timeoutsec <= 0) {
            return;
        }
        DetachedTransactionReaper detachedTransactionReaper = this;
        synchronized (detachedTransactionReaper) {
            this.txns.add(tid);
            if (this.mytimer == null || this.txns.size() == 1) {
                this.addTimer(timeoutsec);
            }
        }
    }

    public synchronized void removeDetachedTID(TransactionUID tid) {
        boolean removed = this.txns.remove(tid);
        if (removed && this.txns.isEmpty()) {
            this.removeTimer();
        }
    }

    public synchronized TransactionUID[] getDetachedTIDs() {
        return this.txns.toArray(new TransactionUID[this.txns.size()]);
    }

    public synchronized void detachOnephasePrepared() {
        long to = (long)Destination.RECONNECT_MULTIPLIER * ((long)timeoutsec * 1000L + Globals.getConnectionManager().getMaxReconnectInterval());
        TransactionState ts = null;
        TransactionUID tid2 = null;
        for (TransactionUID tid2 : this.txns) {
            ts = this.translist.retrieveState(tid2);
            if (ts == null || ts.getState() != 5 || !ts.getOnephasePrepare() || ts.isDetachedFromConnection()) continue;
            ts.detachedFromConnection();
            this.logger.log(8, this.br.getKString("B1432", String.valueOf(tid2) + "[" + String.valueOf(ts) + "]", to));
        }
    }

    public synchronized void destroy() {
        this.destroyed = true;
        if (this.mytimer != null) {
            this.removeTimer();
        }
        this.txns.clear();
    }

    private void addTimer(int timeoutsec) {
        assert (Thread.holdsLock(this));
        assert (this.mytimer == null);
        this.mytimer = new DetachedTransactionTimerTask(timeoutsec);
        try {
            long tm = (long)timeoutsec * 1000L;
            Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1281", timeoutsec));
            timer.schedule(this.mytimer, tm, tm);
        }
        catch (IllegalStateException ex) {
            Globals.getLogger().logStack(8, "B3100", "Failed to schedule detached-transaction reaper " + String.valueOf(this), (Throwable)ex);
        }
    }

    private void removeTimer() {
        assert (Thread.holdsLock(this));
        try {
            if (this.mytimer != null) {
                this.mytimer.cancel();
            }
        }
        catch (IllegalStateException ex) {
            Globals.getLogger().logStack(4, "Failed to cancel detached-transaction reaper timer ", ex);
        }
        this.mytimer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("imq.transaction.detachedTimeout", String.valueOf(timeoutsec));
        ht.put("reconnectionMultiplier", String.valueOf(Destination.RECONNECT_MULTIPLIER));
        ht.put("maxConnectionReconnectInterval(ms)", Globals.getConnectionManager().getMaxReconnectInterval());
        ArrayList list = null;
        DetachedTransactionReaper detachedTransactionReaper = this;
        synchronized (detachedTransactionReaper) {
            list = new ArrayList(this.txns);
        }
        ht.put("DetachedTransactionCount", list.size());
        TransactionUID tid2 = null;
        TransactionState ts = null;
        for (TransactionUID tid2 : list) {
            ts = this.translist.retrieveState(tid2, true);
            ht.put(tid2.toString(), String.valueOf(ts));
        }
        return ht;
    }

    class DetachedTransactionTimerTask
    extends TimerTask {
        private long timeout;

        DetachedTransactionTimerTask(int timeoutsec) {
            this.timeout = (long)timeoutsec * 1000L;
        }

        @Override
        public void run() {
            TransactionHandler rbh = (TransactionHandler)Globals.getPacketRouter(0).getHandler(48);
            long currentTime = System.currentTimeMillis();
            TransactionUID[] tids = DetachedTransactionReaper.this.getDetachedTIDs();
            for (int i = 0; i < tids.length && !DetachedTransactionReaper.this.destroyed; ++i) {
                long timeoutTime;
                TransactionState ts = DetachedTransactionReaper.this.translist.retrieveState(tids[i]);
                if (ts == null) {
                    if (DetachedTransactionReaper.this.translist.retrieveState(tids[i], true) != null) continue;
                    DetachedTransactionReaper.this.removeDetachedTID(tids[i]);
                    continue;
                }
                if (ts.getState() == 5) {
                    if (!ts.getOnephasePrepare()) {
                        DetachedTransactionReaper.this.removeDetachedTID(tids[i]);
                        continue;
                    }
                } else if (ts.getState() != 3 && ts.getState() != 4) {
                    DetachedTransactionReaper.this.removeDetachedTID(tids[i]);
                    continue;
                }
                if (!ts.isDetachedFromConnection() || this.timeout <= 0L) continue;
                long realtimeout = this.timeout;
                if (ts.getState() == 5) {
                    realtimeout = (long)Destination.RECONNECT_MULTIPLIER * (this.timeout + Globals.getConnectionManager().getMaxReconnectInterval());
                }
                if (currentTime < (timeoutTime = ts.getDetachedTime() + realtimeout)) continue;
                try {
                    Object[] args = new String[]{String.valueOf(tids[i]) + "[" + TransactionState.toString(ts.getState()) + "]" + (ts.getOnephasePrepare() ? "onephase=true" : ""), String.valueOf(ts.getCreationTime()), String.valueOf(ts.getDetachedTime())};
                    Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2185", args));
                    rbh.doRollback(DetachedTransactionReaper.this.translist, tids[i], ts.getXid(), null, ts, null, null, RollbackReason.TIMEOUT);
                    DetachedTransactionReaper.this.removeDetachedTID(tids[i]);
                    continue;
                }
                catch (Exception ex) {
                    Globals.getLogger().logStack(16, Globals.getBrokerResources().getKString("B2186", String.valueOf(tids[i]) + "[" + TransactionState.toString(ts.getState()) + "]"), ex);
                }
            }
        }
    }
}

