/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.jaspi.modules;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.jaspi.modules.BaseAuthModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticationAuthModule
extends BaseAuthModule {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthenticationAuthModule.class);
    private String realmName;
    private static final String REALM_KEY = "org.eclipse.jetty.security.jaspi.modules.RealmName";

    public BasicAuthenticationAuthModule() {
    }

    public BasicAuthenticationAuthModule(CallbackHandler callbackHandler, String realmName) {
        super(callbackHandler);
        this.realmName = realmName;
    }

    @Override
    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler callbackHandler, Map options) throws AuthException {
        super.initialize(requestPolicy, responsePolicy, callbackHandler, options);
        this.realmName = (String)options.get(REALM_KEY);
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        String credentials = request.getHeader(HttpHeader.AUTHORIZATION.asString());
        try {
            if (credentials != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Credentials: {}", (Object)credentials);
                }
                if (this.login(clientSubject, credentials, "BASIC", messageInfo)) {
                    return AuthStatus.SUCCESS;
                }
            }
            if (!this.isMandatory(messageInfo)) {
                return AuthStatus.SUCCESS;
            }
            response.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), "basic realm=\"" + this.realmName + "\"");
            response.sendError(401);
            return AuthStatus.SEND_CONTINUE;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new AuthException(e.getMessage());
        }
    }
}

