/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.spi;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.VirtualThreads;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.TryExecutor;

public class DelegatingThreadPool
extends ContainerLifeCycle
implements ThreadPool,
TryExecutor,
VirtualThreads.Configurable {
    private Executor _executor;
    private TryExecutor _tryExecutor;

    public DelegatingThreadPool(Executor executor) {
        this._executor = executor;
        this._tryExecutor = TryExecutor.asTryExecutor((Executor)executor);
        this.addBean(this._executor);
    }

    public Executor getExecutor() {
        return this._executor;
    }

    public void setExecutor(Executor executor) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this.updateBean(this._executor, executor);
        this._executor = executor;
        this._tryExecutor = TryExecutor.asTryExecutor((Executor)executor);
    }

    public void execute(Runnable job) {
        this._executor.execute(job);
    }

    public boolean tryExecute(Runnable task) {
        return this._tryExecutor.tryExecute(task);
    }

    public Executor getVirtualThreadsExecutor() {
        return VirtualThreads.getVirtualThreadsExecutor((Executor)this._executor);
    }

    public void setVirtualThreadsExecutor(Executor executor) {
        if (this._executor instanceof VirtualThreads.Configurable) {
            ((VirtualThreads.Configurable)this._executor).setVirtualThreadsExecutor(executor);
        }
    }

    public int getIdleThreads() {
        Executor executor = this._executor;
        if (executor instanceof ThreadPool) {
            return ((ThreadPool)executor).getIdleThreads();
        }
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)executor;
            return tpe.getPoolSize() - tpe.getActiveCount();
        }
        return -1;
    }

    public int getThreads() {
        Executor executor = this._executor;
        if (executor instanceof ThreadPool) {
            return ((ThreadPool)executor).getThreads();
        }
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)executor;
            return tpe.getPoolSize();
        }
        return -1;
    }

    public boolean isLowOnThreads() {
        Executor executor = this._executor;
        if (executor instanceof ThreadPool) {
            return ((ThreadPool)executor).isLowOnThreads();
        }
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)executor;
            return tpe.getPoolSize() == tpe.getMaximumPoolSize() && tpe.getQueue().size() >= tpe.getPoolSize() - tpe.getActiveCount();
        }
        return false;
    }

    public void join() throws InterruptedException {
        Executor executor = this._executor;
        if (executor instanceof ThreadPool) {
            ((ThreadPool)executor).join();
        } else if (executor instanceof ExecutorService) {
            ((ExecutorService)executor).awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        } else {
            throw new IllegalStateException();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (!(this._executor instanceof LifeCycle) && this._executor instanceof ExecutorService) {
            ((ExecutorService)this._executor).shutdownNow();
        }
    }
}

