/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal.generator;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.http3.internal.VarLenInt;
import org.eclipse.jetty.http3.internal.generator.FrameGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class SettingsGenerator
extends FrameGenerator {
    private final boolean useDirectByteBuffers;

    public SettingsGenerator(boolean useDirectByteBuffers) {
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    @Override
    public int generate(ByteBufferPool.Lease lease, long streamId, Frame frame, Consumer<Throwable> fail) {
        SettingsFrame settingsFrame = (SettingsFrame)frame;
        return this.generateSettings(lease, settingsFrame);
    }

    private int generateSettings(ByteBufferPool.Lease lease, SettingsFrame frame) {
        int length = 0;
        Map<Long, Long> settings = frame.getSettings();
        for (Map.Entry<Long, Long> e : settings.entrySet()) {
            length += VarLenInt.length(e.getKey()) + VarLenInt.length(e.getValue());
        }
        int capacity = VarLenInt.length(frame.getFrameType().type()) + VarLenInt.length(length) + length;
        ByteBuffer buffer = lease.acquire(capacity, this.useDirectByteBuffers);
        VarLenInt.encode(buffer, frame.getFrameType().type());
        VarLenInt.encode(buffer, length);
        for (Map.Entry<Long, Long> e : settings.entrySet()) {
            VarLenInt.encode(buffer, e.getKey());
            VarLenInt.encode(buffer, e.getValue());
        }
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        lease.append(buffer, true);
        return capacity;
    }
}

