/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import jakarta.servlet.Servlet;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;

public class JarServer {
    public static Server createServer(int port) throws Exception {
        Server server = new Server(port);
        Path jarFile = Paths.get("src/main/other/content.jar", new String[0]);
        if (!Files.exists(jarFile, new LinkOption[0])) {
            throw new FileNotFoundException(jarFile.toString());
        }
        ServletContextHandler context = new ServletContextHandler();
        Resource.setDefaultUseCaches((boolean)true);
        Resource base = Resource.newResource((String)("jar:" + jarFile.toAbsolutePath().toUri().toASCIIString() + "!/"));
        context.setBaseResource(base);
        context.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/");
        server.setHandler((Handler)new HandlerList(new Handler[]{context, new DefaultHandler()}));
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = JarServer.createServer(port);
        server.start();
        server.join();
    }
}

