/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server.internal;

import java.util.function.Consumer;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.internal.HTTP3Stream;
import org.eclipse.jetty.http3.internal.HTTP3StreamConnection;
import org.eclipse.jetty.http3.internal.parser.MessageParser;
import org.eclipse.jetty.http3.server.internal.HTTP3StreamServer;
import org.eclipse.jetty.http3.server.internal.HttpChannelOverHTTP3;
import org.eclipse.jetty.http3.server.internal.HttpTransportOverHTTP3;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3Session;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;

public class ServerHTTP3StreamConnection
extends HTTP3StreamConnection {
    private final Connector connector;
    private final HttpConfiguration httpConfiguration;
    private final ServerHTTP3Session session;

    public ServerHTTP3StreamConnection(Connector connector, HttpConfiguration httpConfiguration, QuicStreamEndPoint endPoint, ServerHTTP3Session session, MessageParser parser) {
        super(endPoint, connector.getExecutor(), connector.getByteBufferPool(), parser);
        this.connector = connector;
        this.httpConfiguration = httpConfiguration;
        this.session = session;
    }

    protected void onDataAvailable(long streamId) {
        this.session.onDataAvailable(streamId);
    }

    public Runnable onRequest(HTTP3StreamServer stream, HeadersFrame frame) {
        HttpTransportOverHTTP3 transport = new HttpTransportOverHTTP3(stream);
        HttpChannelOverHTTP3 channel = new HttpChannelOverHTTP3(this.connector, this.httpConfiguration, (EndPoint)this.getEndPoint(), transport, stream);
        stream.setAttachment((Object)channel);
        return channel.onRequest(frame);
    }

    public Runnable onDataAvailable(HTTP3Stream stream) {
        HttpChannelOverHTTP3 channel = (HttpChannelOverHTTP3)((Object)stream.getAttachment());
        return channel.onDataAvailable();
    }

    public Runnable onTrailer(HTTP3Stream stream, HeadersFrame frame) {
        HttpChannelOverHTTP3 channel = (HttpChannelOverHTTP3)((Object)stream.getAttachment());
        return channel.onTrailer(frame);
    }

    public boolean onIdleTimeout(HTTP3Stream stream, Throwable failure, Consumer<Runnable> consumer) {
        HttpChannelOverHTTP3 channel = (HttpChannelOverHTTP3)((Object)stream.getAttachment());
        return channel.onIdleTimeout(failure, consumer);
    }

    public Runnable onFailure(HTTP3Stream stream, Throwable failure) {
        HttpChannelOverHTTP3 channel = (HttpChannelOverHTTP3)((Object)stream.getAttachment());
        return channel.onFailure(failure);
    }
}

