/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.logging.JettyLogger;
import org.eclipse.jetty.logging.JettyLoggerFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StacklessLogging
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(StacklessLogging.class);
    private static final JettyLoggerFactory loggerFactory;
    private final Set<JettyLogger> squelched = new HashSet<JettyLogger>();

    public StacklessLogging(Class<?> ... classesToSquelch) {
        if (loggerFactory == null) {
            return;
        }
        for (Class<?> clazz : classesToSquelch) {
            JettyLogger jettyLogger = loggerFactory.getJettyLogger(clazz.getName());
            if (jettyLogger.isDebugEnabled() || jettyLogger.isHideStacks()) continue;
            jettyLogger.setHideStacks(true);
            this.squelched.add(jettyLogger);
        }
    }

    public StacklessLogging(Package ... packagesToSquelch) {
        if (loggerFactory == null) {
            return;
        }
        for (Package pkg : packagesToSquelch) {
            JettyLogger jettyLogger = loggerFactory.getJettyLogger(pkg.getName());
            if (jettyLogger.isDebugEnabled() || jettyLogger.isHideStacks()) continue;
            jettyLogger.setHideStacks(true);
            this.squelched.add(jettyLogger);
        }
    }

    public StacklessLogging(Logger ... logs) {
        if (loggerFactory == null) {
            return;
        }
        for (Logger log : logs) {
            JettyLogger jettyLogger;
            if (!(log instanceof JettyLogger) || log.isDebugEnabled() || (jettyLogger = (JettyLogger)log).isHideStacks()) continue;
            jettyLogger.setHideStacks(true);
            this.squelched.add(jettyLogger);
        }
    }

    @Override
    public void close() {
        for (JettyLogger log : this.squelched) {
            log.setHideStacks(false);
        }
    }

    static {
        JettyLoggerFactory jettyLoggerFactory = null;
        ILoggerFactory activeLoggerFactory = LoggerFactory.getILoggerFactory();
        if (activeLoggerFactory instanceof JettyLoggerFactory) {
            jettyLoggerFactory = (JettyLoggerFactory)activeLoggerFactory;
        } else {
            LOG.warn("Unable to squelch stacktraces ({} is not a {})", (Object)activeLoggerFactory.getClass().getName(), (Object)JettyLoggerFactory.class.getName());
        }
        loggerFactory = jettyLoggerFactory;
    }
}

