/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.serverfactory;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.server.Server;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServerServiceTracker
implements ServiceTrackerCustomizer {
    private static Logger LOG = LoggerFactory.getLogger((String)JettyServerServiceTracker.class.getName());

    public Object addingService(ServiceReference sr) {
        Bundle contributor = sr.getBundle();
        Server server = (Server)contributor.getBundleContext().getService(sr);
        String name = (String)sr.getProperty("managedServerName");
        if (name == null) {
            throw new IllegalArgumentException("The property managedServerName is mandatory");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding Server {}", (Object)name);
        }
        ServerInstanceWrapper wrapper = new ServerInstanceWrapper(name);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        for (String key : sr.getPropertyKeys()) {
            ((Dictionary)props).put(key, sr.getProperty(key));
        }
        try {
            wrapper.start(server, props);
            LOG.info("Started Server {}", (Object)name);
            return wrapper;
        }
        catch (Exception e) {
            LOG.warn("Failed to start server {}", (Object)name, (Object)e);
            return sr.getBundle().getBundleContext().getService(sr);
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service instanceof ServerInstanceWrapper) {
            ServerInstanceWrapper wrapper = (ServerInstanceWrapper)service;
            try {
                wrapper.stop();
                LOG.info("Stopped Server {}", (Object)wrapper.getManagedServerName());
            }
            catch (Exception e) {
                LOG.warn("Failed to stop server {}", (Object)wrapper.getManagedServerName(), (Object)e);
            }
        }
    }
}

