/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.javax.server.config.JavaxWebSocketServletContainerInitializer;

public class WebSocketJsrServer {
    public static Server createServer(int port) {
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        JavaxWebSocketServletContainerInitializer.configure((ServletContextHandler)context, (servletContext, serverContainer) -> serverContainer.addEndpoint(EchoJsrSocket.class));
        server.setHandler((Handler)new HandlerList(new Handler[]{context, new DefaultHandler()}));
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = WebSocketJsrServer.createServer(port);
        server.start();
        server.join();
    }

    @ServerEndpoint(value="/echo")
    public static class EchoJsrSocket {
        @OnMessage
        public void onMessage(Session session, String message) {
            session.getAsyncRemote().sendText(message);
        }
    }
}

