/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal.generator;

import java.util.function.Consumer;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.FrameType;
import org.eclipse.jetty.http3.internal.generator.CancelPushGenerator;
import org.eclipse.jetty.http3.internal.generator.FrameGenerator;
import org.eclipse.jetty.http3.internal.generator.GoAwayGenerator;
import org.eclipse.jetty.http3.internal.generator.MaxPushIdGenerator;
import org.eclipse.jetty.http3.internal.generator.SettingsGenerator;
import org.eclipse.jetty.io.ByteBufferPool;

public class ControlGenerator {
    private final FrameGenerator[] generators = new FrameGenerator[FrameType.maxType() + 1];

    public ControlGenerator(boolean useDirectByteBuffers) {
        this.generators[FrameType.CANCEL_PUSH.type()] = new CancelPushGenerator();
        this.generators[FrameType.SETTINGS.type()] = new SettingsGenerator(useDirectByteBuffers);
        this.generators[FrameType.GOAWAY.type()] = new GoAwayGenerator(useDirectByteBuffers);
        this.generators[FrameType.MAX_PUSH_ID.type()] = new MaxPushIdGenerator();
    }

    public int generate(ByteBufferPool.Lease lease, long streamId, Frame frame, Consumer<Throwable> fail) {
        return this.generators[frame.getFrameType().type()].generate(lease, streamId, frame, fail);
    }
}

