/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs.programming.server;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DetectorConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.unixdomain.server.UnixDomainServerConnector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.ajax.AsyncJSON;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ServerDocs {
    public void http() throws Exception {
        HttpConnectionFactory http = new HttpConnectionFactory();
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{http});
        connector.setPort(8080);
        server.addConnector((Connector)connector);
        server.start();
    }

    public void httpUnix() throws Exception {
        HttpConnectionFactory http = new HttpConnectionFactory();
        Server server = new Server();
        UnixDomainServerConnector connector = new UnixDomainServerConnector(server, new ConnectionFactory[]{http});
        connector.setUnixDomainPath(Path.of("/tmp/jetty.sock", new String[0]));
        server.addConnector((Connector)connector);
        server.start();
    }

    public void tlsHttp() throws Exception {
        HttpConnectionFactory http = new HttpConnectionFactory();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath("/path/to/keystore.p12");
        sslContextFactory.setKeyStorePassword("secret");
        SslConnectionFactory tls = new SslConnectionFactory(sslContextFactory, http.getProtocol());
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{tls, http});
        connector.setPort(8443);
        server.addConnector((Connector)connector);
        server.start();
    }

    public void detector() throws Exception {
        HttpConnectionFactory http = new HttpConnectionFactory();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath("/path/to/keystore.p12");
        sslContextFactory.setKeyStorePassword("secret");
        SslConnectionFactory tls = new SslConnectionFactory(sslContextFactory, http.getProtocol());
        Server server = new Server();
        DetectorConnectionFactory tlsDetector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{tls});
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{tlsDetector, http});
        connector.setPort(8181);
        server.addConnector((Connector)connector);
        server.start();
    }

    private void invokeApplication(Map<String, Object> request, Callback callback) {
    }

    public void httpCompliance() {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setHttpCompliance(HttpCompliance.RFC7230);
    }

    public void httpComplianceCustom() {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        HttpCompliance customHttpCompliance = HttpCompliance.from((String)"RFC7230,MULTIPLE_CONTENT_LENGTHS");
        httpConfiguration.setHttpCompliance(customHttpCompliance);
    }

    public void uriCompliance() {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setUriCompliance(UriCompliance.RFC3986);
    }

    public void uriComplianceCustom() {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        UriCompliance customUriCompliance = UriCompliance.from((String)"RFC3986,-AMBIGUOUS_PATH_SEPARATOR");
        httpConfiguration.setUriCompliance(customUriCompliance);
    }

    public void cookieCompliance() {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setRequestCookieCompliance(CookieCompliance.RFC6265);
        httpConfiguration.setResponseCookieCompliance(CookieCompliance.RFC6265);
    }

    public void cookieComplianceCustom() {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        CookieCompliance customUriCompliance = CookieCompliance.from((String)"RFC6265,-RESERVED_NAMES_NOT_DOLLAR_PREFIXED");
        httpConfiguration.setRequestCookieCompliance(customUriCompliance);
        httpConfiguration.setResponseCookieCompliance(CookieCompliance.RFC6265);
    }

    static interface JSONHTTPService {
        public void service(JSONHTTPRequest var1, JSONHTTPResponse var2, Callback var3);
    }

    class JSONHTTPResponse {
        JSONHTTPResponse() {
        }
    }

    class JSONHTTPRequest {
        JSONHTTPRequest() {
        }
    }

    public class JSONHTTPConnection
    extends AbstractConnection {
        private final AsyncJSON parser;
        private final IteratingCallback callback;

        public JSONHTTPConnection(EndPoint endPoint, Executor executor) {
            super(endPoint, executor);
            this.parser = new AsyncJSON.Factory().newAsyncJSON();
            this.callback = new JSONHTTPIteratingCallback();
        }

        public void onOpen() {
            super.onOpen();
            this.fillInterested();
        }

        public void onFillable() {
            this.callback.iterate();
        }

        private class JSONHTTPIteratingCallback
        extends IteratingCallback {
            private ByteBuffer buffer;

            private JSONHTTPIteratingCallback() {
            }

            protected IteratingCallback.Action process() throws Throwable {
                int filled;
                if (this.buffer == null) {
                    this.buffer = BufferUtil.allocate((int)JSONHTTPConnection.this.getInputBufferSize(), (boolean)true);
                }
                while ((filled = JSONHTTPConnection.this.getEndPoint().fill(this.buffer)) > 0) {
                    boolean parsed = JSONHTTPConnection.this.parser.parse(this.buffer);
                    if (!parsed) continue;
                    Map request = (Map)JSONHTTPConnection.this.parser.complete();
                    ServerDocs.this.invokeApplication(request, (Callback)this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                if (filled == 0) {
                    this.buffer = null;
                    JSONHTTPConnection.this.fillInterested();
                    return IteratingCallback.Action.IDLE;
                }
                return IteratingCallback.Action.SUCCEEDED;
            }

            protected void onCompleteSuccess() {
                JSONHTTPConnection.this.getEndPoint().close();
            }

            protected void onCompleteFailure(Throwable cause) {
                JSONHTTPConnection.this.getEndPoint().close(cause);
            }
        }
    }

    public class JSONHTTPConnectionFactory
    extends AbstractConnectionFactory {
        public JSONHTTPConnectionFactory() {
            super("JSONHTTP");
        }

        public Connection newConnection(Connector connector, EndPoint endPoint) {
            JSONHTTPConnection connection = new JSONHTTPConnection(endPoint, connector.getExecutor());
            return this.configure(connection, connector, endPoint);
        }
    }
}

