/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.demos.AbstractRestServlet;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.ajax.JSON;

public class SerialRestServlet
extends AbstractRestServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long start = NanoTime.now();
        String[] keywords = SerialRestServlet.sanitize(request.getParameter("items")).split(",");
        LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
        for (String itemName : keywords) {
            URL url = new URL(this.restURL(itemName));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            Map query = (Map)new JSON().fromJSON((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())));
            Object[] auctions = (Object[])query.get("Item");
            if (auctions == null) continue;
            for (Object o : auctions) {
                Map auction = (Map)o;
                results.add(auction);
            }
        }
        String thumbs = this.generateThumbs(results);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html><head>");
        out.println("<style type='text/css'>  img.thumb:hover {height:50px}  img.thumb {vertical-align:text-top}  span.red {color: #ff0000}  span.green {color: #00ff00}  iframe {border: 0px}</style>");
        out.println("</head><body><small>");
        long total = NanoTime.since((long)start);
        out.print("<b>Blocking: " + SerialRestServlet.sanitize(request.getParameter("items")) + "</b><br/>");
        out.print("Total Time: " + this.ms(total) + "ms<br/>");
        out.print("Thread held (<span class='red'>red</span>): " + this.ms(total) + "ms<br/>");
        out.println("<img border='0px' src='asyncrest/red.png'   height='20px' width='" + this.width(total) + "px'>");
        out.println("<hr />");
        out.println(thumbs);
        out.println("</small>");
        out.println("</body></html>");
        out.close();
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

