/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.http.internal;

import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.client.http.internal.HttpChannelOverHTTP3;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.internal.HTTP3ErrorCode;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReceiverOverHTTP3
extends HttpReceiver
implements Stream.Client.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(HttpReceiverOverHTTP3.class);
    private volatile boolean notifySuccess;

    protected HttpReceiverOverHTTP3(HttpChannelOverHTTP3 channel) {
        super((HttpChannel)channel);
    }

    protected HttpChannelOverHTTP3 getHttpChannel() {
        return (HttpChannelOverHTTP3)super.getHttpChannel();
    }

    protected void receive() {
        HttpExchange exchange;
        if (LOG.isDebugEnabled()) {
            LOG.debug("resuming response processing on {}", (Object)this);
        }
        if ((exchange = this.getHttpExchange()) == null) {
            return;
        }
        if (this.notifySuccess) {
            this.responseSuccess(exchange);
        } else {
            this.getHttpChannel().getStream().demand();
        }
    }

    public void onResponse(Stream.Client stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpResponse httpResponse = exchange.getResponse();
        MetaData.Response response = (MetaData.Response)frame.getMetaData();
        httpResponse.version(response.getHttpVersion()).status(response.getStatus()).reason(response.getReason());
        if (this.responseBegin(exchange)) {
            HttpFields headers = response.getFields();
            for (HttpField header : headers) {
                if (this.responseHeader(exchange, header)) continue;
                return;
            }
            this.notifySuccess = frame.isLast();
            if (this.responseHeaders(exchange)) {
                int status = response.getStatus();
                if (frame.isLast() || HttpStatus.isInterim((int)status)) {
                    this.responseSuccess(exchange);
                } else {
                    stream.demand();
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("stalling response processing, no demand after headers on {}", (Object)this);
            }
        }
    }

    public void onDataAvailable(Stream.Client stream) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        try {
            Stream.Data data = stream.readData();
            if (data != null) {
                ByteBuffer byteBuffer = data.getByteBuffer();
                if (byteBuffer.hasRemaining()) {
                    Callback callback;
                    boolean proceed;
                    if (data.isLast()) {
                        this.notifySuccess = true;
                    }
                    if (proceed = this.responseContent(exchange, byteBuffer, callback = Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, () -> ((Stream.Data)data).complete(), x -> {
                        data.complete();
                        if (this.responseFailure((Throwable)x)) {
                            stream.reset(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), x);
                        }
                    }))) {
                        if (data.isLast()) {
                            this.responseSuccess(exchange);
                        } else {
                            stream.demand();
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("stalling response processing, no demand after {} on {}", (Object)data, (Object)this);
                    }
                } else {
                    data.complete();
                    if (data.isLast()) {
                        this.responseSuccess(exchange);
                    } else {
                        stream.demand();
                    }
                }
            } else {
                stream.demand();
            }
        }
        catch (Throwable x2) {
            Throwable failure = x2;
            if (x2 instanceof UncheckedIOException) {
                failure = x2.getCause();
            }
            exchange.getRequest().abort(failure);
        }
    }

    public void onTrailer(Stream.Client stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpFields trailers = frame.getMetaData().getFields();
        trailers.forEach(arg_0 -> ((HttpResponse)exchange.getResponse()).trailer(arg_0));
        this.responseSuccess(exchange);
    }

    public boolean onIdleTimeout(Stream.Client stream, Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        return !exchange.abort(failure);
    }

    public void onFailure(Stream.Client stream, long error, Throwable failure) {
        this.responseFailure(failure);
    }

    protected void reset() {
        super.reset();
        this.notifySuccess = false;
    }
}

