/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

public class FileServerXml {
    public static Server createServer(int port, Path baseResource) throws Exception {
        Resource fileServerXml = Resource.newSystemResource((String)"fileserver.xml");
        XmlConfiguration configuration = new XmlConfiguration(fileServerXml);
        configuration.getProperties().put("http.port", Integer.toString(port));
        configuration.getProperties().put("fileserver.baseresource", baseResource.toAbsolutePath().toString());
        return (Server)configuration.configure();
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Path userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        Server server = FileServerXml.createServer(port, userDir);
        server.start();
        server.join();
    }
}

