/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.StartLog;

public abstract class FileInitializer {
    protected final Set<String> _scheme = new HashSet<String>();
    protected final BaseHome _basehome;

    protected FileInitializer(BaseHome basehome, String ... scheme) {
        this._basehome = basehome;
        if (scheme != null) {
            for (String s : scheme) {
                this._scheme.add(s.toLowerCase());
            }
        }
    }

    public boolean isApplicable(URI uri) {
        if (this._scheme.isEmpty()) {
            return uri == null;
        }
        return uri != null && this._scheme.contains(uri.getScheme().toLowerCase());
    }

    public abstract boolean create(URI var1, String var2) throws IOException;

    public boolean check(URI uri, String location) throws IOException {
        if (location != null) {
            boolean isDir = location.endsWith("/");
            Path destination = this.getDestination(uri, location);
            if (FS.exists(destination)) {
                if (isDir) {
                    if (!Files.isDirectory(destination, new LinkOption[0])) {
                        throw new IOException("Invalid: path should be a directory (but isn't): " + location);
                    }
                    if (!FS.canReadDirectory(destination)) {
                        throw new IOException("Unable to read directory: " + location);
                    }
                } else if (!FS.canReadFile(destination)) {
                    throw new IOException("Unable to read file: " + location);
                }
                return true;
            }
            StartLog.error("Missing Required File: %s", this._basehome.toShortForm(location));
            return false;
        }
        return true;
    }

    protected Path getDestination(URI uri, String location) throws IOException {
        boolean isDestDir;
        if (location == null) {
            return null;
        }
        Path destination = this._basehome.getBasePath(location);
        if (destination != null && !destination.startsWith(this._basehome.getBasePath())) {
            throw new IOException("For security reasons, Jetty start is unable to process file resource not in ${jetty.base} - " + location);
        }
        boolean bl = isDestDir = Files.isDirectory(destination, new LinkOption[0]) || !Files.exists(destination, new LinkOption[0]) && location.endsWith("/");
        if (isDestDir && uri != null && uri.getSchemeSpecificPart().contains("/") && !uri.getSchemeSpecificPart().endsWith("/")) {
            destination = destination.resolve(uri.getSchemeSpecificPart().substring(uri.getSchemeSpecificPart().lastIndexOf(47) + 1));
        }
        return destination;
    }

    protected void download(URI uri, Path destination) throws IOException {
        if (FS.ensureDirectoryExists(destination.getParent())) {
            StartLog.info("mkdir " + this._basehome.toShortForm(destination.getParent()), new Object[0]);
        }
        StartLog.info("download %s to %s", uri, this._basehome.toShortForm(destination));
        URLConnection connection = uri.toURL().openConnection();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)uri.toURL().openConnection();
            http.setInstanceFollowRedirects(true);
            http.setAllowUserInteraction(false);
            int status = http.getResponseCode();
            if (status != 200) {
                throw new IOException("URL GET Failure [" + status + "/" + http.getResponseMessage() + "] on " + uri);
            }
        }
        try (InputStream in = connection.getInputStream();){
            Files.copy(in, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected boolean isFilePresent(Path ... paths) throws IOException {
        for (Path file : paths) {
            if (!Files.exists(file, new LinkOption[0])) continue;
            if (Files.isDirectory(file, new LinkOption[0])) {
                throw new IOException("Directory in the way: " + file.toAbsolutePath());
            }
            if (!Files.isReadable(file)) {
                throw new IOException("File not readable: " + file.toAbsolutePath());
            }
            return true;
        }
        return false;
    }

    public boolean copyDirectory(Path source, Path destination) throws IOException {
        boolean modified = false;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(source);){
            for (Path from : stream) {
                Path to = destination.resolve(from.getFileName());
                if (Files.isDirectory(from, new LinkOption[0])) {
                    if (FS.ensureDirectoryExists(to)) {
                        StartLog.info("mkdir " + this._basehome.toShortForm(to), new Object[0]);
                        modified = true;
                    }
                    if (!this.copyDirectory(from, to)) continue;
                    modified = true;
                    continue;
                }
                if (Files.exists(to, new LinkOption[0])) continue;
                StartLog.info("copy %s to %s", this._basehome.toShortForm(from), this._basehome.toShortForm(to));
                Files.copy(from, to, new CopyOption[0]);
                modified = true;
            }
        }
        return modified;
    }
}

