/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.hazelcast.session;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;

public class SessionDataSerializer
implements StreamSerializer<SessionData> {
    public static final int __TYPEID = 99;

    public int getTypeId() {
        return 99;
    }

    public void destroy() {
    }

    public void write(ObjectDataOutput out, SessionData data) throws IOException {
        out.writeUTF(data.getId());
        out.writeUTF(data.getContextPath());
        out.writeUTF(data.getVhost());
        out.writeLong(data.getAccessed());
        out.writeLong(data.getLastAccessed());
        out.writeLong(data.getCreated());
        out.writeLong(data.getCookieSet());
        out.writeUTF(data.getLastNode());
        out.writeLong(data.getExpiry());
        out.writeLong(data.getMaxInactiveMs());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            SessionData.serializeAttributes((SessionData)data, (ObjectOutputStream)oos);
            out.writeByteArray(baos.toByteArray());
        }
    }

    public SessionData read(ObjectDataInput in) throws IOException {
        String id = in.readUTF();
        String contextPath = in.readUTF();
        String vhost = in.readUTF();
        long accessed = in.readLong();
        long lastAccessed = in.readLong();
        long created = in.readLong();
        long cookieSet = in.readLong();
        String lastNode = in.readUTF();
        long expiry = in.readLong();
        long maxInactiveMs = in.readLong();
        SessionData sd = new SessionData(id, contextPath, vhost, created, accessed, lastAccessed, maxInactiveMs);
        ByteArrayInputStream bais = new ByteArrayInputStream(in.readByteArray());
        try (ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream((InputStream)bais);){
            SessionData.deserializeAttributes((SessionData)sd, (ObjectInputStream)ois);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        sd.setCookieSet(cookieSet);
        sd.setLastNode(lastNode);
        sd.setExpiry(expiry);
        return sd;
    }
}

