/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.fileinits;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jetty.start.StartLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenMetadata {
    private String groupId;
    private String artifactId;
    private String version;
    private String lastUpdated;
    private String snapshotTimestamp;
    private String snapshotBuildNumber;
    private final Map<String, Snapshot> snapshots = new HashMap<String, Snapshot>();

    public MavenMetadata(Path metadataXml) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (InputStream input = Files.newInputStream(metadataXml, new OpenOption[0]);){
            Document doc = builder.parse(input);
            this.parseRoot(doc.getDocumentElement(), metadataXml);
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    public String getSnapshotBuildNumber() {
        return this.snapshotBuildNumber;
    }

    public Collection<Snapshot> getSnapshots() {
        return this.snapshots.values();
    }

    public Snapshot getSnapshot(String classifier, String extension) {
        Snapshot snapshot = this.snapshots.get(MavenMetadata.asSuffix(classifier, extension));
        if (snapshot == null) {
            snapshot = new Snapshot();
            snapshot.value = String.format("%s-%s-%s", this.getVersion().replaceFirst("-SNAPSHOT$", ""), this.snapshotTimestamp, this.snapshotBuildNumber);
        }
        return snapshot;
    }

    public static boolean isExpiredTimestamp(String lastUpdated) {
        ZoneId utc = ZoneId.of("UTC");
        LocalDate today = LocalDate.now(utc);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(utc);
        try {
            LocalDate lastUpdatedDate = LocalDate.parse(lastUpdated, formatter).atStartOfDay().toLocalDate();
            return today.isAfter(lastUpdatedDate);
        }
        catch (DateTimeParseException e) {
            StartLog.debug(e);
            return false;
        }
    }

    private static String asSuffix(String classifier, String type) {
        if (classifier != null) {
            return String.format("-%s.%s", classifier, type);
        }
        return String.format(".%s", type);
    }

    private List<Node> listOf(NodeList nodeList) {
        ArrayList<Node> children = new ArrayList<Node>();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            children.add(nodeList.item(i));
        }
        return children;
    }

    private void parseRoot(Element root, Path metadataXml) throws IOException {
        if (!root.getNodeName().equals("metadata")) {
            throw new IOException("Unrecognized maven-metadata.xml <" + root.getNodeName() + ">: " + metadataXml);
        }
        this.listOf(root.getChildNodes()).stream().filter(node -> node.getNodeType() == 1).map(node -> (Element)node).forEach(elem -> {
            switch (elem.getNodeName()) {
                case "groupId": {
                    this.groupId = elem.getTextContent();
                    break;
                }
                case "artifactId": {
                    this.artifactId = elem.getTextContent();
                    break;
                }
                case "version": {
                    this.version = elem.getTextContent();
                    break;
                }
                case "versioning": {
                    this.parseVersioning((Element)elem, metadataXml);
                }
            }
        });
    }

    private void parseVersioning(Element versioning, Path metadataXml) {
        this.listOf(versioning.getChildNodes()).stream().filter(node -> node.getNodeType() == 1).map(node -> (Element)node).forEach(elem -> {
            switch (elem.getNodeName()) {
                case "snapshot": {
                    this.parseSnapshot((Element)elem);
                    break;
                }
                case "lastUpdated": {
                    this.lastUpdated = elem.getTextContent();
                    break;
                }
                case "snapshotVersions": {
                    this.parseSnapshotVersions((Element)elem);
                }
            }
        });
    }

    private void parseSnapshot(Element snapshot) {
        this.listOf(snapshot.getChildNodes()).stream().filter(node -> node.getNodeType() == 1).map(node -> (Element)node).forEach(elem -> {
            switch (elem.getNodeName()) {
                case "timestamp": {
                    this.snapshotTimestamp = elem.getTextContent();
                    break;
                }
                case "buildNumber": {
                    this.snapshotBuildNumber = elem.getTextContent();
                }
            }
        });
    }

    private void parseSnapshotVersions(Element snapshotVersions) {
        this.listOf(snapshotVersions.getChildNodes()).stream().filter(node -> node.getNodeType() == 1).map(node -> (Element)node).forEach(elem -> {
            if ("snapshotVersion".equals(elem.getNodeName())) {
                this.parseSnapshotVersion((Element)elem);
            }
        });
    }

    private void parseSnapshotVersion(Element snapshotVersion) {
        Snapshot snapshot = new Snapshot();
        this.listOf(snapshotVersion.getChildNodes()).stream().filter(node -> node.getNodeType() == 1).map(node -> (Element)node).forEach(elem -> {
            switch (elem.getNodeName()) {
                case "classifier": {
                    snapshot.classifier = elem.getTextContent();
                    break;
                }
                case "extension": {
                    snapshot.extension = elem.getTextContent();
                    break;
                }
                case "value": {
                    snapshot.value = elem.getTextContent();
                    break;
                }
                case "updated": {
                    snapshot.updated = elem.getTextContent();
                }
            }
        });
        this.snapshots.put(snapshot.toSuffix(), snapshot);
    }

    public static class Snapshot {
        String classifier;
        String extension;
        String value;
        String updated;

        private String toSuffix() {
            return MavenMetadata.asSuffix(this.classifier, this.extension);
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getUpdated() {
            return this.updated;
        }

        public String getValue() {
            return this.value;
        }
    }
}

