/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.foreign.incubator.windows;

import java.lang.invoke.VarHandle;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jdk.incubator.foreign.CLinker;
import jdk.incubator.foreign.MemoryLayout;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.ResourceScope;

public class sockaddr_windows {
    private static final short AF_INET = 2;
    private static final short AF_INET6 = 23;

    public static MemorySegment convert(SocketAddress socketAddress, ResourceScope scope) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Expected InetSocketAddress instance, got: " + socketAddress);
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetAddress address = inetSocketAddress.getAddress();
        if (address instanceof Inet4Address) {
            MemorySegment sin = sockaddr_in.allocate(scope);
            sockaddr_in.set_sin_family(sin, (short)2);
            sockaddr_in.set_sin_port(sin, (short)inetSocketAddress.getPort());
            sockaddr_in.set_sin_addr(sin, ByteBuffer.wrap(address.getAddress()).getInt());
            return sin;
        }
        if (address instanceof Inet6Address) {
            MemorySegment sin6 = sockaddr_in6.allocate(scope);
            sockaddr_in6.set_sin6_family(sin6, (short)23);
            sockaddr_in6.set_sin6_port(sin6, (short)inetSocketAddress.getPort());
            sockaddr_in6.set_sin6_addr(sin6, address.getAddress());
            sockaddr_in6.set_sin6_scope_id(sin6, 0);
            sockaddr_in6.set_sin6_flowinfo(sin6, 0);
            return sin6;
        }
        throw new UnsupportedOperationException("Unsupported InetAddress: " + address);
    }

    private static class sockaddr_in {
        private static final MemoryLayout LAYOUT = MemoryLayout.structLayout((MemoryLayout[])new MemoryLayout[]{CLinker.C_SHORT.withName("sin_family"), CLinker.C_SHORT.withName("sin_port"), CLinker.C_INT.withName("sin_addr"), MemoryLayout.sequenceLayout((long)8L, (MemoryLayout)CLinker.C_CHAR).withName("sin_zero")}).withName("sockaddr_in");
        private static final VarHandle sin_family = LAYOUT.varHandle(Short.TYPE, new MemoryLayout.PathElement[]{MemoryLayout.PathElement.groupElement((String)"sin_family")});
        private static final VarHandle sin_port = LAYOUT.varHandle(Short.TYPE, new MemoryLayout.PathElement[]{MemoryLayout.PathElement.groupElement((String)"sin_port")});
        private static final VarHandle sin_addr = LAYOUT.varHandle(Integer.TYPE, new MemoryLayout.PathElement[]{MemoryLayout.PathElement.groupElement((String)"sin_addr")});

        private sockaddr_in() {
        }

        public static MemorySegment allocate(ResourceScope scope) {
            return MemorySegment.allocateNative((MemoryLayout)LAYOUT, (ResourceScope)scope);
        }

        public static void set_sin_family(MemorySegment sin, short value) {
            sin_family.set(sin, value);
        }

        public static void set_sin_port(MemorySegment sin, short value) {
            sin_port.set(sin, value);
        }

        public static void set_sin_addr(MemorySegment sin, int value) {
            sin_addr.set(sin, value);
        }
    }

    private static class sockaddr_in6 {
        private static final MemoryLayout LAYOUT = MemoryLayout.structLayout((MemoryLayout[])new MemoryLayout[]{CLinker.C_SHORT.withName("sin6_family"), CLinker.C_SHORT.withName("sin6_port"), CLinker.C_INT.withName("sin6_flowinfo"), MemoryLayout.sequenceLayout((long)16L, (MemoryLayout)CLinker.C_CHAR).withName("sin6_addr"), CLinker.C_INT.withName("sin6_scope_id")}).withName("sockaddr_in6");
        private static final VarHandle sin6_family = LAYOUT.varHandle(Short.TYPE, new MemoryLayout.PathElement[]{MemoryLayout.PathElement.groupElement((String)"sin6_family")});
        private static final VarHandle sin6_port = LAYOUT.varHandle(Short.TYPE, new MemoryLayout.PathElement[]{MemoryLayout.PathElement.groupElement((String)"sin6_port")});
        private static final VarHandle sin6_scope_id = LAYOUT.varHandle(Integer.TYPE, new MemoryLayout.PathElement[]{MemoryLayout.PathElement.groupElement((String)"sin6_scope_id")});
        private static final VarHandle sin6_flowinfo = LAYOUT.varHandle(Integer.TYPE, new MemoryLayout.PathElement[]{MemoryLayout.PathElement.groupElement((String)"sin6_flowinfo")});

        private sockaddr_in6() {
        }

        public static MemorySegment allocate(ResourceScope scope) {
            return MemorySegment.allocateNative((MemoryLayout)LAYOUT, (ResourceScope)scope);
        }

        public static void set_sin6_addr(MemorySegment sin6, byte[] value) {
            sin6.asSlice(8L, 16L).asByteBuffer().order(ByteOrder.nativeOrder()).put(value);
        }

        public static void set_sin6_family(MemorySegment sin6, short value) {
            sin6_family.set(sin6, value);
        }

        public static void set_sin6_port(MemorySegment sin6, short value) {
            sin6_port.set(sin6, value);
        }

        public static void set_sin6_scope_id(MemorySegment sin6, int value) {
            sin6_scope_id.set(sin6, value);
        }

        public static void set_sin6_flowinfo(MemorySegment sin6, int value) {
            sin6_flowinfo.set(sin6, value);
        }
    }
}

