/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class WizardNewLinkPage
extends WizardPage {
    private String initialLinkTarget;
    private int type;
    private boolean createLink = false;
    private IContainer container;
    private Text linkTargetField;
    private Button browseButton;
    private Button variablesButton;

    public WizardNewLinkPage(String pageName, int type) {
        super(pageName);
        this.type = type;
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        topLevel.setLayout((Layout)layout);
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(font);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topLevel, "org.eclipse.ui.ide.new_link_wizard_page_context");
        final Button createLinkButton = new Button(topLevel, 32);
        if (this.type == 1) {
            createLinkButton.setText(IDEWorkbenchMessages.WizardNewLinkPage_linkFileButton);
        } else {
            createLinkButton.setText(IDEWorkbenchMessages.WizardNewLinkPage_linkFolderButton);
        }
        createLinkButton.setSelection(this.createLink);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        createLinkButton.setLayoutData((Object)data);
        createLinkButton.setFont(font);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardNewLinkPage.this.createLink = createLinkButton.getSelection();
                WizardNewLinkPage.this.browseButton.setEnabled(WizardNewLinkPage.this.createLink);
                WizardNewLinkPage.this.variablesButton.setEnabled(WizardNewLinkPage.this.createLink);
                WizardNewLinkPage.this.linkTargetField.setEnabled(WizardNewLinkPage.this.createLink);
                WizardNewLinkPage.this.setPageComplete(WizardNewLinkPage.this.validatePage());
            }
        };
        createLinkButton.addSelectionListener((SelectionListener)listener);
        this.createLinkLocationGroup(topLevel, this.createLink);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    private void createLinkLocationGroup(Composite locationGroup, boolean enabled) {
        Font font = locationGroup.getFont();
        Label fill = new Label(locationGroup, 0);
        GridData data = new GridData();
        Button button = new Button(locationGroup, 32);
        data.widthHint = button.computeSize((int)-1, (int)-1).x;
        button.dispose();
        fill.setLayoutData((Object)data);
        this.linkTargetField = new Text(locationGroup, 2048);
        data = new GridData(768);
        this.linkTargetField.setLayoutData((Object)data);
        this.linkTargetField.setFont(font);
        this.linkTargetField.setEnabled(enabled);
        this.linkTargetField.addModifyListener(e -> this.setPageComplete(this.validatePage()));
        if (this.initialLinkTarget != null) {
            this.linkTargetField.setText(this.initialLinkTarget);
        }
        this.browseButton = new Button(locationGroup, 8);
        this.setButtonLayoutData(this.browseButton);
        this.browseButton.setFont(font);
        this.browseButton.setText(IDEWorkbenchMessages.WizardNewLinkPage_browseButton);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardNewLinkPage.this.handleLinkTargetBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        fill = new Label(locationGroup, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        fill.setLayoutData((Object)data);
        this.variablesButton = new Button(locationGroup, 8);
        this.setButtonLayoutData(this.variablesButton);
        this.variablesButton.setFont(font);
        this.variablesButton.setText(IDEWorkbenchMessages.WizardNewLinkPage_variablesButton);
        this.variablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardNewLinkPage.this.handleVariablesButtonPressed();
            }
        });
        this.variablesButton.setEnabled(enabled);
    }

    public String getLinkTarget() {
        if (this.createLink && this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            return this.linkTargetField.getText();
        }
        return null;
    }

    private void handleLinkTargetBrowseButtonPressed() {
        String linkTargetName = this.linkTargetField.getText();
        String selection = null;
        IFileStore store = null;
        if (!(linkTargetName.length() <= 0 || (store = IDEResourceInfoUtils.getFileStore(linkTargetName)) != null && store.fetchInfo().exists())) {
            store = null;
        }
        if (this.type == 1) {
            FileDialog dialog = new FileDialog(this.getShell(), 0x10000000);
            if (store != null) {
                if (store.fetchInfo().isDirectory()) {
                    dialog.setFilterPath(linkTargetName);
                } else {
                    dialog.setFileName(linkTargetName);
                }
            }
            selection = dialog.open();
        } else {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10000000);
            if (store != null) {
                if (!store.fetchInfo().isDirectory()) {
                    linkTargetName = store.getParent().getName();
                }
                if (linkTargetName != null) {
                    dialog.setFilterPath(linkTargetName);
                }
            }
            dialog.setMessage(IDEWorkbenchMessages.WizardNewLinkPage_targetSelectionLabel);
            selection = dialog.open();
        }
        if (selection != null) {
            this.linkTargetField.setText(selection);
        }
    }

    private void handleVariablesButtonPressed() {
        IPathVariableManager pathVariableManager;
        IPath path;
        String[] variableNames;
        PathVariableSelectionDialog dialog = new PathVariableSelectionDialog(this.getShell(), this.type);
        if (dialog.open() == 0 && (variableNames = (String[])dialog.getResult()) != null && (path = (pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager()).getValue(variableNames[0])) != null) {
            this.linkTargetField.setText(path.toOSString());
        }
    }

    public void setContainer(IContainer container) {
        this.container = container;
    }

    public void setLinkTarget(String target) {
        this.initialLinkTarget = target;
        if (this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            this.linkTargetField.setText(target);
        }
    }

    private boolean validateFileType(IFileStore linkTargetStore) {
        boolean valid = true;
        if (this.type == 1 && linkTargetStore.fetchInfo().isDirectory()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetNotFile);
            valid = false;
        } else if (this.type == 2 && !linkTargetStore.fetchInfo().isDirectory()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetNotFolder);
            valid = false;
        }
        return valid;
    }

    private boolean validateLinkTargetName(String linkTargetName) {
        boolean valid = true;
        if ("".equals(linkTargetName)) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetEmpty);
            valid = false;
        } else {
            Path path = new Path("");
            if (!path.isValidPath(linkTargetName)) {
                this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetInvalid);
                valid = false;
            }
        }
        return valid;
    }

    private boolean validatePage() {
        String linkTargetName;
        boolean valid = true;
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        if (this.createLink && (valid = this.validateLinkTargetName(linkTargetName = this.linkTargetField.getText()))) {
            IFileStore linkTargetFile = IDEResourceInfoUtils.getFileStore(linkTargetName);
            if (linkTargetFile == null || !linkTargetFile.fetchInfo().exists()) {
                this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetNonExistent);
                valid = false;
            } else {
                IStatus locationStatus = workspace.validateLinkLocation((IResource)this.container, (IPath)new Path(linkTargetName));
                if (!locationStatus.isOK()) {
                    this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetLocationInvalid);
                    valid = false;
                } else {
                    valid = this.validateFileType(linkTargetFile);
                }
            }
        }
        if (valid) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }
}

