/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.Jdk;

class SoftClassCache {
    private final ConcurrentMap<Path, JdkClasses> jdks = new ConcurrentHashMap<Path, JdkClasses>();

    SoftClassCache() {
    }

    void clear() {
        this.jdks.clear();
    }

    public byte[] getClassBytes(Jdk jdk, Path path) throws IOException {
        return this.jdks.computeIfAbsent(jdk.path, JdkClasses::new).get(path);
    }

    private static final class ClassBytes {
        private final Path path;
        private volatile boolean empty;
        private volatile SoftReference<byte[]> bytes;

        public ClassBytes(Path path) {
            this.path = path;
        }

        public byte[] getBytes() throws IOException {
            byte[] bs;
            if (this.empty) {
                return null;
            }
            SoftReference<byte[]> reference = this.bytes;
            if (reference != null && (bs = reference.get()) != null) {
                return bs;
            }
            byte[] readBytes = JRTUtil.safeReadBytes(this.path);
            if (readBytes == null) {
                this.empty = true;
                return null;
            }
            this.bytes = new SoftReference<byte[]>(readBytes);
            return readBytes;
        }
    }

    private static final class JdkClasses {
        private final ConcurrentMap<Path, ClassBytes> classes = new ConcurrentHashMap<Path, ClassBytes>(10007);
        private final Path jdkPath;

        public JdkClasses(Path jdkPath) {
            this.jdkPath = jdkPath;
        }

        public byte[] get(Path path) throws IOException {
            return this.classes.computeIfAbsent(path, ClassBytes::new).getBytes();
        }

        public String toString() {
            return "Class Cache for " + String.valueOf(this.jdkPath);
        }
    }
}

