/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroIdElement;
import org.eclipse.ui.internal.intro.impl.model.util.BundleUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class IntroTheme
extends AbstractIntroIdElement {
    private static final String ATT_NAME = "name";
    private static final String ATT_PATH = "path";
    private String name;
    private String path;
    private Hashtable<String, String> properties;
    private boolean scalable;

    public IntroTheme(IConfigurationElement element) {
        super(element);
        this.name = element.getAttribute(ATT_NAME);
        this.path = element.getAttribute(ATT_PATH);
        this.path = BundleUtil.getResolvedResourceLocation(this.path, this.getBundle());
        this.scalable = "true".equals(element.getAttribute("scalable"));
        this.loadProperties(element);
    }

    public IntroTheme(Element element, Bundle bundle) {
        super(element, bundle);
    }

    public IntroTheme(Element element, Bundle bundle, String base) {
        super(element, bundle, base);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int getType() {
        return 262144;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isScalable() {
        return this.scalable;
    }

    private void loadProperties(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren("property");
        if (children.length == 0) {
            return;
        }
        this.properties = new Hashtable();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement property = children[i];
            String name = property.getAttribute(ATT_NAME);
            String value = property.getAttribute("value");
            if (name != null && value != null) {
                this.properties.put(name, value);
            }
            ++i;
        }
        this.properties.put("id", this.getId());
    }
}

