/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.P2Package;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.RequirementType;
import org.eclipse.oomph.p2.VersionSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementImpl
extends ModelElementImpl
implements Requirement {
    private static final String ANNOTATION_KEY = "platform:/plugin/org.eclipse.oomph.base/model/legacy/setup.ecore#//Component/type";
    protected static final String ID_EDEFAULT = null;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String NAMESPACE_EDEFAULT = "org.eclipse.equinox.p2.iu";
    protected String namespace = "org.eclipse.equinox.p2.iu";
    protected static final VersionRange VERSION_RANGE_EDEFAULT = (VersionRange)P2Factory.eINSTANCE.createFromString(P2Package.eINSTANCE.getVersionRange(), "0.0.0");
    protected VersionRange versionRange = VERSION_RANGE_EDEFAULT;
    protected static final boolean OPTIONAL_EDEFAULT = false;
    protected static final boolean GREEDY_EDEFAULT = true;
    protected boolean greedy = true;
    protected static final String FILTER_EDEFAULT = null;
    protected String filter = FILTER_EDEFAULT;
    protected static final RequirementType TYPE_EDEFAULT = RequirementType.NONE;
    protected static final int MIN_EDEFAULT = 1;
    protected int min = 1;
    protected static final int MAX_EDEFAULT = 1;
    protected int max = 1;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;

    protected RequirementImpl() {
    }

    protected EClass eStaticClass() {
        return P2Package.Literals.REQUIREMENT;
    }

    public String getID() {
        return this.name;
    }

    public void setID(String newID) {
        this.setName(newID);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String newNamespace) {
        String oldNamespace = this.namespace;
        this.namespace = newNamespace;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldNamespace, (Object)this.namespace));
        }
    }

    @Override
    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    @Override
    public void setVersionRange(VersionRange newVersionRange) {
        VersionRange oldVersionRange = this.versionRange;
        this.versionRange = newVersionRange;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldVersionRange, (Object)this.versionRange));
        }
    }

    @Override
    public void setVersionRange(Version version, VersionSegment segment) {
        this.setVersionRange(P2Factory.eINSTANCE.createVersionRange(version, segment));
    }

    @Override
    public IRequirement toIRequirement() {
        String namespace = this.getNamespace();
        String name = this.getName();
        VersionRange versionRange = this.getVersionRange();
        IMatchExpression<IInstallableUnit> filter = this.getMatchExpression();
        int min = this.getMin();
        boolean greedy = this.isGreedy();
        int max = this.getMax();
        String description = null;
        IRequirement requirement = name == null || !name.startsWith("(") ? MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)versionRange, filter, (int)min, (int)max, (boolean)greedy, description) : MetadataFactory.createRequirement((String)namespace, (String)name, filter, (int)min, (int)max, (boolean)greedy, description);
        return requirement;
    }

    @Override
    public boolean isOptional() {
        return this.min <= 0;
    }

    @Override
    public void setOptional(boolean newOptional) {
        this.setMin(newOptional ? 0 : 1);
    }

    public boolean isFeature() {
        String id = this.getName();
        return id != null && id.endsWith(".feature.group");
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(String newFilter) {
        String oldFilter = this.filter;
        this.filter = newFilter;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldFilter, (Object)this.filter));
        }
    }

    @Override
    public RequirementType getType() {
        String name = this.getName();
        if (name != null) {
            if (name.endsWith(".feature.group")) {
                return RequirementType.FEATURE;
            }
            if (name.endsWith(".plain.project")) {
                return RequirementType.PROJECT;
            }
        }
        return RequirementType.NONE;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public void setMin(int newMin) {
        boolean oldOptional = this.isOptional();
        int oldMin = this.min;
        this.min = newMin;
        boolean newOptional = this.isOptional();
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldMin, this.min));
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldOptional, newOptional));
        }
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public void setMax(int newMax) {
        int oldMax = this.max;
        this.max = newMax;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldMax, this.max));
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public boolean isGreedy() {
        return this.greedy;
    }

    @Override
    public void setGreedy(boolean newGreedy) {
        boolean oldGreedy = this.greedy;
        this.greedy = newGreedy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldGreedy, this.greedy));
        }
    }

    @Override
    public IMatchExpression<IInstallableUnit> getMatchExpression() {
        String filter = this.getFilter();
        return RequirementImpl.parseMatchExpression(filter);
    }

    @Override
    public void setMatchExpression(IMatchExpression<IInstallableUnit> matchExpression) {
        String filter = RequirementImpl.formatMatchExpression(matchExpression);
        this.setFilter(filter);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getID();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getNamespace();
            }
            case 4: {
                return this.getVersionRange();
            }
            case 5: {
                return this.isOptional();
            }
            case 6: {
                return this.isGreedy();
            }
            case 7: {
                return this.getFilter();
            }
            case 8: {
                return this.getType();
            }
            case 9: {
                return this.getMin();
            }
            case 10: {
                return this.getMax();
            }
            case 11: {
                return this.getDescription();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setID((String)newValue);
                return;
            }
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setNamespace((String)newValue);
                return;
            }
            case 4: {
                this.setVersionRange((VersionRange)newValue);
                return;
            }
            case 5: {
                this.setOptional((Boolean)newValue);
                return;
            }
            case 6: {
                this.setGreedy((Boolean)newValue);
                return;
            }
            case 7: {
                this.setFilter((String)newValue);
                return;
            }
            case 9: {
                this.setMin((Integer)newValue);
                return;
            }
            case 10: {
                this.setMax((Integer)newValue);
                return;
            }
            case 11: {
                this.setDescription((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setID(ID_EDEFAULT);
                return;
            }
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setNamespace(NAMESPACE_EDEFAULT);
                return;
            }
            case 4: {
                this.setVersionRange(VERSION_RANGE_EDEFAULT);
                return;
            }
            case 5: {
                this.setOptional(false);
                return;
            }
            case 6: {
                this.setGreedy(true);
                return;
            }
            case 7: {
                this.setFilter(FILTER_EDEFAULT);
                return;
            }
            case 9: {
                this.setMin(1);
                return;
            }
            case 10: {
                this.setMax(1);
                return;
            }
            case 11: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.min == 0;
            }
            case 9: {
                return this.min != 0 && this.min != 1;
            }
        }
        return this.eIsSetGen(featureID);
    }

    private boolean eIsSetGen(int featureID) {
        switch (featureID) {
            case 1: {
                return ID_EDEFAULT == null ? this.getID() != null : !ID_EDEFAULT.equals(this.getID());
            }
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return NAMESPACE_EDEFAULT == null ? this.namespace != null : !NAMESPACE_EDEFAULT.equals(this.namespace);
            }
            case 4: {
                return VERSION_RANGE_EDEFAULT == null ? this.versionRange != null : !VERSION_RANGE_EDEFAULT.equals((Object)this.versionRange);
            }
            case 5: {
                return this.isOptional();
            }
            case 6: {
                return !this.greedy;
            }
            case 7: {
                return FILTER_EDEFAULT == null ? this.filter != null : !FILTER_EDEFAULT.equals(this.filter);
            }
            case 8: {
                return this.getType() != TYPE_EDEFAULT;
            }
            case 9: {
                return this.min != 1;
            }
            case 10: {
                return this.max != 1;
            }
            case 11: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                this.setVersionRange((Version)arguments.get(0), (VersionSegment)((Object)arguments.get(1)));
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    protected void eMigrate() {
        Annotation annotation = this.getAnnotation("http://www.eclipse.org/oomph/Migrator");
        if (annotation != null) {
            EMap details = annotation.getDetails();
            String value = (String)details.get((Object)ANNOTATION_KEY);
            boolean remove = false;
            if ("eclipse.feature".equals(value)) {
                String id = this.getName();
                if (id != null) {
                    this.setName(String.valueOf(id) + ".feature.group");
                    remove = true;
                }
            } else if ("osgi.bundle".equals(value)) {
                remove = true;
            }
            if (remove) {
                details.removeKey((Object)ANNOTATION_KEY);
                if (annotation.getDetails().isEmpty()) {
                    this.getAnnotations().remove((Object)annotation);
                }
            }
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer();
        result.append(this.namespace);
        result.append(':');
        result.append(this.name);
        if (this.versionRange != null && !this.versionRange.equals((Object)VersionRange.emptyRange)) {
            result.append(" ");
            result.append(this.versionRange);
        }
        if (this.min != 1) {
            result.append(" (min=" + this.min + ")");
        }
        if (this.max != 1) {
            result.append(" (max=" + this.max + ")");
        }
        if (this.greedy && this.min == 0) {
            result.append(" (greedy)");
        }
        if (this.filter != null) {
            result.append(" (filter=" + this.filter + ")");
        }
        if (this.description != null) {
            result.append(" (description=" + this.description + ")");
        }
        return result.toString();
    }

    public static IMatchExpression<IInstallableUnit> parseMatchExpression(String filter) {
        if (filter == null) {
            return null;
        }
        return InstallableUnit.parseFilter((String)filter);
    }

    public static String formatMatchExpression(IMatchExpression<IInstallableUnit> matchExpression) {
        if (matchExpression == null) {
            return null;
        }
        return matchExpression.getParameters()[0].toString();
    }
}

