/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.jdt.impl;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.jdt.JDTPackage;
import org.eclipse.oomph.setup.jdt.JRETask;

public class JRETaskImpl
extends SetupTaskImpl
implements JRETask {
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected static final String LOCATION_EDEFAULT = null;
    protected String location = LOCATION_EDEFAULT;

    protected JRETaskImpl() {
    }

    protected EClass eStaticClass() {
        return JDTPackage.Literals.JRE_TASK;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldVersion, (Object)this.version));
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String newLocation) {
        String oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldLocation, (Object)this.location));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getVersion();
            }
            case 11: {
                return this.getLocation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setVersion((String)newValue);
                return;
            }
            case 11: {
                this.setLocation((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 11: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 11: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (version: ");
        result.append(this.version);
        result.append(", location: ");
        result.append(this.location);
        result.append(')');
        return result.toString();
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        return JREHelper.isNeeded(context, this.getVersion(), this.getLocation());
    }

    public void perform(SetupTaskContext context) throws Exception {
        JREHelper.perform(context, this.getVersion(), this.getLocation());
    }

    private static class JREHelper {
        private JREHelper() {
        }

        public static void perform(SetupTaskContext context, String version, String location) throws Exception {
            IVMInstallType[] types;
            IVMInstallType[] iVMInstallTypeArray = types = JavaRuntime.getVMInstallTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstallType type = iVMInstallTypeArray[n2];
                if ("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType".equals(type.getId())) {
                    context.log("Configurating a " + version + " JRE for location " + location);
                    File installLocation = new File(location);
                    IStatus validationStatus = type.validateInstallLocation(installLocation);
                    if (!validationStatus.isOK()) {
                        throw new CoreException(validationStatus);
                    }
                    VMStandin vmStandin = new VMStandin(type, EcoreUtil.generateUUID());
                    vmStandin.setInstallLocation(installLocation);
                    vmStandin.setName("JRE for " + version);
                    IVMInstall realVM = vmStandin.convertToRealVM();
                    JavaRuntime.setDefaultVMInstall((IVMInstall)realVM, (IProgressMonitor)new NullProgressMonitor());
                    if ("J2SE-1.4".equals(version)) {
                        IExecutionEnvironment[] executionEnvironments;
                        IExecutionEnvironment[] iExecutionEnvironmentArray = executionEnvironments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
                        int n3 = executionEnvironments.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IExecutionEnvironment executionEnvironment = iExecutionEnvironmentArray[n4];
                            String id = executionEnvironment.getId();
                            if (id.equals("CDC-1.1/Foundation-1.1") && executionEnvironment.getDefaultVM() == null) {
                                executionEnvironment.setDefaultVM(realVM);
                                break;
                            }
                            ++n4;
                        }
                    }
                    return;
                }
                ++n2;
            }
        }

        public static boolean isNeeded(SetupTaskContext context, String version, String location) throws Exception {
            IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
            int n = iVMInstallTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstallType vmInstallType = iVMInstallTypeArray[n2];
                IVMInstall[] iVMInstallArray = vmInstallType.getVMInstalls();
                int n3 = iVMInstallArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVMInstall vmInstall = iVMInstallArray[n4];
                    File installLocation = vmInstall.getInstallLocation();
                    if (new File(location).equals(installLocation)) {
                        return false;
                    }
                    ++n4;
                }
                ++n2;
            }
            return true;
        }
    }
}

