/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.sync.tests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.LocalDataProvider;
import org.eclipse.oomph.setup.internal.sync.RemoteDataProvider;
import org.eclipse.oomph.setup.internal.sync.SyncUtil;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.internal.sync.Synchronizer;
import org.eclipse.oomph.setup.internal.sync.SynchronizerAdapter;
import org.eclipse.oomph.setup.internal.sync.SynchronizerException;
import org.eclipse.oomph.setup.internal.sync.SynchronizerListener;
import org.eclipse.oomph.setup.sync.RemoteData;
import org.eclipse.oomph.setup.sync.SyncAction;
import org.eclipse.oomph.setup.sync.SyncActionType;
import org.eclipse.oomph.setup.sync.SyncDelta;
import org.eclipse.oomph.setup.sync.SyncPolicy;
import org.eclipse.oomph.tests.AbstractTest;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.userstorage.IBlob;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.StorageFactory;
import org.eclipse.userstorage.spi.ISettings;
import org.eclipse.userstorage.spi.StorageCache;
import org.eclipse.userstorage.tests.util.ServerFixture;
import org.eclipse.userstorage.util.Settings;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.junit.Assert;

public final class TestWorkstation {
    private static final boolean REUSE_USER_HOMES = true;
    private static TestWorkstation lastWorkstation;
    private final ResourceSet resourceSet = SyncUtil.createResourceSet();
    private final Map<Integer, TestWorkstation> workstations;
    private final int id;
    private final File userHome;
    private final File userSetup;
    private final TestSynchronizer synchronizer;
    private File remoteFile;
    private User user;

    public TestWorkstation(ServerFixture serverFixture, Map<Integer, TestWorkstation> workstations, int id) throws Exception {
        this.workstations = workstations;
        this.id = id;
        this.userHome = this.createUserHome();
        this.userSetup = new File(this.userHome, "user.setup");
        Settings.MemorySettings settings = new Settings.MemorySettings();
        settings.setValue("cNhDr0INs8T109P8h6E1r_GvU3I", serverFixture.getService().getServiceURI().toString());
        StorageFactory factory = new StorageFactory((ISettings)settings);
        RemoteDataProvider.SyncStorageCache cache = new RemoteDataProvider.SyncStorageCache(this.userHome);
        IStorage storage = factory.create("cNhDr0INs8T109P8h6E1r_GvU3I", (StorageCache)cache);
        LocalDataProvider localDataProvider = new LocalDataProvider(this.userSetup);
        RemoteDataProvider remoteDataProvider = new RemoteDataProvider(storage);
        this.synchronizer = new TestSynchronizer((DataProvider)localDataProvider, (DataProvider)remoteDataProvider, cache.getFolder());
        this.log("Create workstation " + this.userHome);
    }

    public File getUserHome() {
        return this.userHome;
    }

    public User getUser() {
        if (this.user == null) {
            URI uri = URI.createFileURI((String)this.userSetup.getAbsolutePath());
            if (this.resourceSet.getURIConverter().exists(uri, null)) {
                this.user = (User)this.loadObject(uri, (EClassifier)SetupPackage.Literals.USER);
            } else {
                this.user = SetupFactory.eINSTANCE.createUser();
                this.user.setName("Test User");
                Resource resource = this.resourceSet.createResource(uri);
                resource.getContents().add((Object)this.user);
            }
        }
        return this.user;
    }

    public List<PreferenceTask> getPreferenceTasks() {
        ArrayList<PreferenceTask> result = new ArrayList<PreferenceTask>();
        this.collectPreferenceTasks((EList<SetupTask>)this.getUser().getSetupTasks(), result);
        return result;
    }

    public String get(String key) {
        return this.getPreference((EList<SetupTask>)this.getUser().getSetupTasks(), key);
    }

    public TestWorkstation set(String key, String value) {
        this.log("Set " + key + " = " + value);
        EList tasks = this.getUser().getSetupTasks();
        for (SetupTask task : tasks) {
            PreferenceTask preferenceTask;
            if (!(task instanceof PreferenceTask) || !key.equals((preferenceTask = (PreferenceTask)task).getKey())) continue;
            preferenceTask.setValue(value);
            return this;
        }
        PreferenceTask preferenceTask = SetupFactory.eINSTANCE.createPreferenceTask();
        preferenceTask.setKey(key);
        preferenceTask.setValue(value);
        tasks.add((Object)preferenceTask);
        return this;
    }

    public TestWorkstation remove(String key) {
        this.log("Remove " + key);
        for (SetupTask task : this.getUser().getSetupTasks()) {
            PreferenceTask preferenceTask;
            if (!(task instanceof PreferenceTask) || !key.equals((preferenceTask = (PreferenceTask)task).getKey())) continue;
            EcoreUtil.remove((EObject)preferenceTask);
            return this;
        }
        return this;
    }

    public TestWorkstation save() {
        if (this.user != null) {
            this.log("Save");
            BaseUtil.saveEObject((EObject)this.user);
        }
        return this;
    }

    public TestSynchronization synchronize() throws Exception {
        return this.synchronizer.synchronize();
    }

    public TestWorkstation commit() throws Exception {
        return this.synchronize().commitAnd();
    }

    public TestSynchronization commitFail(FailureHandler handler) throws Exception {
        return this.synchronize().commitFail(handler);
    }

    public TestWorkstation assertCount(int count) {
        MatcherAssert.assertThat((Object)this.getPreferenceTasks().size(), (Matcher)CoreMatchers.is((Object)count));
        return this;
    }

    public TestWorkstation assertSet(String key, String value) {
        MatcherAssert.assertThat((Object)this.get(key), (Matcher)CoreMatchers.is((Object)value));
        return this;
    }

    public TestWorkstation assertRemoved(String key) {
        MatcherAssert.assertThat((Object)this.get(key), (Matcher)IsNull.nullValue());
        return this;
    }

    public TestWorkstation assertIncluded(String key) throws Exception {
        Map<String, SyncPolicy> preferencePolicies = this.getPreferencePolicies();
        MatcherAssert.assertThat((Object)preferencePolicies.get(key), (Matcher)CoreMatchers.is((Object)SyncPolicy.INCLUDE));
        return this;
    }

    public TestWorkstation assertExcluded(String key) throws Exception {
        Map<String, SyncPolicy> preferencePolicies = this.getPreferencePolicies();
        MatcherAssert.assertThat((Object)preferencePolicies.get(key), (Matcher)CoreMatchers.is((Object)SyncPolicy.EXCLUDE));
        return this;
    }

    public TestWorkstation assertNoPolicy(String key) throws Exception {
        Map<String, SyncPolicy> preferencePolicies = this.getPreferencePolicies();
        MatcherAssert.assertThat((Object)preferencePolicies.get(key), (Matcher)IsNull.nullValue());
        return this;
    }

    public Map<String, SyncPolicy> getPreferencePolicies() throws Exception {
        RemoteData remoteData = this.getRemoteData();
        EMap policies = remoteData.getPolicies();
        HashMap<String, SyncPolicy> preferencePolicies = new HashMap<String, SyncPolicy>();
        for (TestWorkstation workstation : this.workstations.values()) {
            if (workstation == this) continue;
            this.collectPreferencePolicies(preferencePolicies, (EMap<String, SyncPolicy>)policies, workstation.getPreferenceTasks());
        }
        this.collectPreferencePolicies(preferencePolicies, (EMap<String, SyncPolicy>)policies, this.getPreferenceTasks());
        this.collectPreferencePolicies(preferencePolicies, (EMap<String, SyncPolicy>)policies, (List<? extends SetupTask>)remoteData.getSetupTasks());
        return preferencePolicies;
    }

    public RemoteData getRemoteData() throws Exception {
        if (this.remoteFile == null) {
            this.remoteFile = File.createTempFile("remote-data-", ".tmp");
            this.remoteFile.deleteOnExit();
            IStorage tmpStorage = this.createTmpStorage();
            IBlob tmpBlob = tmpStorage.getBlob("user_setup");
            InputStream tmpContents = tmpBlob.getContents();
            RemoteDataProvider.uncompressContents((InputStream)tmpContents, (File)this.remoteFile);
        }
        return (RemoteData)this.loadObject(URI.createFileURI((String)this.remoteFile.getAbsolutePath()), (EClassifier)DataProvider.Location.REMOTE.getDataType());
    }

    public TestWorkstation log(Object msg) {
        if (this != lastWorkstation) {
            AbstractTest.log();
            AbstractTest.log((Object)(this + ":"));
        }
        lastWorkstation = this;
        AbstractTest.log((Object)("   " + msg));
        return this;
    }

    public String toString() {
        return "Workstation " + this.id;
    }

    private <T extends EObject> T loadObject(URI uri, EClassifier classifier) {
        Resource resource = this.resourceSet.getResource(uri, true);
        return (T)((EObject)BaseUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)classifier));
    }

    private IStorage createTmpStorage() throws Exception {
        RemoteDataProvider remoteDataProvider = (RemoteDataProvider)this.synchronizer.getRemoteSnapshot().getDataProvider();
        IStorage storage = remoteDataProvider.getStorage();
        Settings.MemorySettings settings = new Settings.MemorySettings();
        settings.setValue("cNhDr0INs8T109P8h6E1r_GvU3I", storage.getService().getServiceURI().toString());
        StorageFactory factory = new StorageFactory((ISettings)settings);
        return factory.create("cNhDr0INs8T109P8h6E1r_GvU3I");
    }

    private File createUserHome() {
        File folder = new File(PropertiesUtil.getTmpDir(), "test-user-" + this.id);
        IOUtil.deleteBestEffort((File)folder, (boolean)false);
        folder.mkdirs();
        return folder;
    }

    private String getPreference(EList<SetupTask> tasks, String key) {
        for (SetupTask task : tasks) {
            CompoundTask compoundTask;
            String value;
            if (task instanceof PreferenceTask) {
                PreferenceTask preferenceTask = (PreferenceTask)task;
                if (!key.equals(preferenceTask.getKey())) continue;
                return preferenceTask.getValue();
            }
            if (!(task instanceof CompoundTask) || (value = this.getPreference((EList<SetupTask>)(compoundTask = (CompoundTask)task).getSetupTasks(), key)) == null) continue;
            return value;
        }
        return null;
    }

    private void collectPreferenceTasks(EList<SetupTask> tasks, List<PreferenceTask> result) {
        for (SetupTask task : tasks) {
            if (task instanceof PreferenceTask) {
                PreferenceTask preferenceTask = (PreferenceTask)task;
                result.add(preferenceTask);
                continue;
            }
            if (!(task instanceof CompoundTask)) continue;
            CompoundTask compoundTask = (CompoundTask)task;
            this.collectPreferenceTasks((EList<SetupTask>)compoundTask.getSetupTasks(), result);
        }
    }

    private void collectPreferencePolicies(Map<String, SyncPolicy> preferencePolicies, EMap<String, SyncPolicy> policies, List<? extends SetupTask> tasks) {
        for (SetupTask setupTask : tasks) {
            PreferenceTask preferenceTask;
            String id;
            SyncPolicy policy;
            if (!(setupTask instanceof PreferenceTask) || (policy = (SyncPolicy)policies.get((Object)(id = (preferenceTask = (PreferenceTask)setupTask).getID()))) == null) continue;
            String key = preferenceTask.getKey();
            preferencePolicies.put(key, policy);
        }
    }

    public static interface FailureHandler {
        public void handleFailure(Exception var1) throws Exception;

        public static class Expect
        implements FailureHandler {
            private final Class<? extends Exception> expectedException;

            public Expect(Class<? extends Exception> expectedException) {
                this.expectedException = expectedException;
            }

            @Override
            public final void handleFailure(Exception ex) throws Exception {
                MatcherAssert.assertThat((Object)ex, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(this.expectedException)));
                this.handleFailure();
            }

            protected void handleFailure() throws Exception {
            }
        }
    }

    public final class TestSynchronization
    extends Synchronization {
        public TestSynchronization(Synchronizer synchronizer, boolean deferLocal) throws IOException {
            super(synchronizer, deferLocal);
        }

        public TestSynchronizer getSynchronizer() {
            return (TestSynchronizer)super.getSynchronizer();
        }

        public SyncAction getPreferenceAction(String key) {
            for (Map.Entry entry : this.getActions().entrySet()) {
                SyncAction action = (SyncAction)entry.getValue();
                if (!this.isPreferenceAction(key, action)) continue;
                return action;
            }
            return null;
        }

        private boolean isPreferenceAction(String key, SyncAction action) {
            return action != null && (this.isPreferenceDelta(key, action.getLocalDelta()) || this.isPreferenceDelta(key, action.getRemoteDelta()));
        }

        private boolean isPreferenceDelta(String key, SyncDelta delta) {
            return delta != null && (this.isPreferenceTask(key, delta.getOldTask()) || this.isPreferenceTask(key, delta.getNewTask()));
        }

        private boolean isPreferenceTask(String key, SetupTask task) {
            PreferenceTask preferenceTask;
            return task instanceof PreferenceTask && key.equals((preferenceTask = (PreferenceTask)task).getKey());
        }

        public TestSynchronization resolve(String id, SyncActionType resolvedType) {
            super.resolve(id, resolvedType);
            return this;
        }

        public TestSynchronization resolvePreference(String key, SyncActionType resolvedType) {
            String id;
            SyncAction action = this.getPreferenceAction(key);
            if (action != null && (id = this.getID(action)) != null) {
                this.resolve(id, resolvedType);
            }
            return this;
        }

        public TestSynchronization exclude(String key) {
            String id;
            SyncAction action = this.getPreferenceAction(key);
            if (action != null && (id = this.getID(action)) != null) {
                this.resolve(id, SyncActionType.EXCLUDE);
            }
            return this;
        }

        public TestSynchronization pickLocal(String key) {
            SyncAction action = this.getPreferenceAction(key);
            if (action != null) {
                this.pick(action, action.getLocalDelta(), SyncActionType.SET_LOCAL, SyncActionType.REMOVE_LOCAL);
            }
            return this;
        }

        public TestSynchronization pickRemote(String key) {
            SyncAction action = this.getPreferenceAction(key);
            if (action != null) {
                this.pick(action, action.getRemoteDelta(), SyncActionType.SET_REMOTE, SyncActionType.REMOVE_REMOTE);
            }
            return this;
        }

        private void pick(SyncAction action, SyncDelta delta, SyncActionType setActionType, SyncActionType removeActionType) {
            String id = this.getID(action);
            if (id != null) {
                if (delta.getNewTask() == null) {
                    this.resolve(id, removeActionType);
                } else {
                    this.resolve(id, setActionType);
                }
            }
        }

        public TestWorkstation commitAnd() throws IOException, DataProvider.NotCurrentException {
            this.commit();
            return TestWorkstation.this;
        }

        public TestSynchronization commitFail(FailureHandler handler) throws Exception {
            try {
                this.commit();
            }
            catch (Exception ex) {
                handler.handleFailure(ex);
                return this;
            }
            Assert.fail((String)"Commit should have failed");
            return this;
        }

        public TestSynchronization assertActions(int count) {
            MatcherAssert.assertThat((Object)this.getActions().size(), (Matcher)CoreMatchers.is((Object)count));
            return this;
        }

        public TestSynchronization assertUnresolved(int count) {
            MatcherAssert.assertThat((Object)this.getUnresolvedActions().size(), (Matcher)CoreMatchers.is((Object)count));
            return this;
        }

        public TestSynchronization assertComputed(String key, SyncActionType type) {
            MatcherAssert.assertThat((Object)this.getPreferenceAction(key).getComputedType(), (Matcher)CoreMatchers.is((Object)type));
            return this;
        }

        public TestSynchronization assertResolved(String key, SyncActionType type) {
            MatcherAssert.assertThat((Object)this.getPreferenceAction(key).getResolvedType(), (Matcher)CoreMatchers.is((Object)type));
            return this;
        }

        public TestSynchronization assertEffective(String key, SyncActionType type) {
            MatcherAssert.assertThat((Object)this.getPreferenceAction(key).getEffectiveType(), (Matcher)CoreMatchers.is((Object)type));
            return this;
        }
    }

    public final class TestSynchronizer
    extends Synchronizer {
        private final SynchronizerListener listener;

        public TestSynchronizer(DataProvider localDataProvider, DataProvider remoteDataProvider, File syncFolder) {
            super(localDataProvider, remoteDataProvider, syncFolder);
            this.listener = new SynchronizerAdapter(){

                public void syncStarted(Synchronization synchronization) {
                    TestWorkstation.this.log("Synchronize");
                }

                public void actionResolved(Synchronization synchronization, SyncAction action, String id) {
                    TestWorkstation.this.log("Resolve " + id + " from " + action.getComputedType() + " to " + action.getResolvedType());
                }

                public void commitStarted(Synchronization synchronization) {
                    TestWorkstation.this.log("Commit");
                }

                public void commitFinished(Synchronization synchronization, Throwable t) {
                    if (t != null) {
                        TestWorkstation.this.log(t.getMessage());
                    } else if (((TestSynchronizer)TestSynchronizer.this).TestWorkstation.this.remoteFile != null) {
                        ((TestSynchronizer)TestSynchronizer.this).TestWorkstation.this.remoteFile.delete();
                        ((TestSynchronizer)TestSynchronizer.this).TestWorkstation.this.remoteFile = null;
                    }
                    ((TestSynchronizer)TestSynchronizer.this).TestWorkstation.this.user = null;
                    URI uri = URI.createFileURI((String)((TestSynchronizer)TestSynchronizer.this).TestWorkstation.this.userSetup.getAbsolutePath());
                    Resource resource = ((TestSynchronizer)TestSynchronizer.this).TestWorkstation.this.resourceSet.getResource(uri, false);
                    if (resource != null) {
                        ((TestSynchronizer)TestSynchronizer.this).TestWorkstation.this.resourceSet.getResources().remove((Object)resource);
                    }
                }
            };
            this.addListener(this.listener);
        }

        public TestWorkstation ws() {
            return TestWorkstation.this;
        }

        protected TestSynchronization createSynchronization(boolean deferLocal) throws IOException {
            return new TestSynchronization(this, deferLocal);
        }

        public synchronized TestSynchronization synchronize() throws IOException, SynchronizerException {
            return (TestSynchronization)super.synchronize();
        }
    }
}

