/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal.geomapbrowser;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.nebula.widgets.geomap.internal.geomapbrowser.Page;
import org.eclipse.nebula.widgets.geomap.internal.geomapbrowser.TitleControl;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PageContainer
extends Composite {
    private Composite content;
    private StackLayout stackLayout;
    private ArrayList<Page> pages = new ArrayList();
    private int activePageIndex = -1;

    public PageContainer(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(e -> this.widgetDisposed(e));
        this.adapt((Control)this);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.stackLayout = new StackLayout();
        TitleControl title = new TitleControl(this, null);
        this.adapt((Control)title);
        title.setLayoutData(new GridData(4, 1, true, false));
        title.setText("SWT MapWidget");
        this.content = new Composite((Composite)this, 0);
        this.content.setLayout((Layout)this.stackLayout);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.adapt((Control)this.content);
    }

    protected void widgetDisposed(DisposeEvent e) {
    }

    public void setPages(Page ... pages) {
        this.pages.clear();
        this.pages.addAll(Arrays.asList(pages));
    }

    public Page[] getPages() {
        return this.pages.toArray(new Page[this.pages.size()]);
    }

    public int indexOfPage(Page page) {
        return this.pages.indexOf(page);
    }

    public int getActivePageIndex() {
        return this.activePageIndex;
    }

    public void showPage(int index) {
        this.stackLayout.topControl = this.pages.get(index).getControl(this, this.content);
        this.content.layout();
        this.activePageIndex = index;
    }

    public void adapt(Control control) {
        control.setBackground(this.getDisplay().getSystemColor(1));
    }
}

