/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal.geomapbrowser;

import java.text.NumberFormat;
import java.util.logging.Logger;
import org.eclipse.nebula.widgets.geomap.GeoMap;
import org.eclipse.nebula.widgets.geomap.GeoMapUtil;
import org.eclipse.nebula.widgets.geomap.internal.InternalGeoMapListener;
import org.eclipse.nebula.widgets.geomap.internal.TileRef;
import org.eclipse.nebula.widgets.geomap.internal.geomapbrowser.AbstractPage;
import org.eclipse.nebula.widgets.geomap.internal.geomapbrowser.GeoMapBrowser;
import org.eclipse.nebula.widgets.geomap.internal.geomapbrowser.Page;
import org.eclipse.nebula.widgets.geomap.internal.geomapbrowser.PageContainer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class InfoPage
extends AbstractPage
implements Page,
InternalGeoMapListener {
    private static final Logger log = Logger.getLogger(InfoPage.class.getName());
    private final GeoMapBrowser mapBrowser;
    private Table table;
    private Spec[] specs;
    private int tilePaintCount;
    private long controlPaintTime;
    private int tileCacheUsed;
    private int tileCacheSize;

    public InfoPage(GeoMapBrowser mapBrowser) {
        this.mapBrowser = mapBrowser;
        this.specs = new Spec[]{new Spec(this, "Zoom"){

            @Override
            public String computeValue() {
                return Integer.toString(this.geoMap.getZoom());
            }
        }, new Spec(this, "Map Size"){

            @Override
            public String computeValue() {
                Point size = this.geoMap.getSize();
                return size.x + ", " + size.y;
            }
        }, new Spec(this, "Map Position"){

            @Override
            public String computeValue() {
                Point position = this.geoMap.getMapPosition();
                return position.x + ", " + position.y;
            }
        }, new Spec(this, "Center Position"){

            @Override
            public String computeValue() {
                Point position = this.geoMap.getCenterPosition();
                return position.x + ", " + position.y;
            }
        }, new Spec(this, "Paint time"){

            @Override
            public String computeValue() {
                return controlPaintTime + " ms";
            }
        }, new Spec(this, "Number painted tiles"){

            @Override
            public String computeValue() {
                return tilePaintCount + " of " + NumberFormat.getIntegerInstance().format((long)(1 << this.geoMap.getZoom()) * (long)(1 << this.geoMap.getZoom()));
            }
        }, new Spec(this, "Tile cache usage"){

            @Override
            public String computeValue() {
                return String.format("Usage: %3d / %3d ", tileCacheUsed, tileCacheSize);
            }
        }, new Spec(this, "Longitude/Latitude"){

            @Override
            public String computeValue() {
                Point p = this.geoMap.getCursorPosition();
                int zoom = this.geoMap.getZoom();
                return InfoPage.format(GeoMapUtil.position2lon(p.x, zoom)) + ", " + InfoPage.format(GeoMapUtil.position2lat(p.y, zoom));
            }
        }};
    }

    private static String format(double d) {
        return String.format("%.5f", d);
    }

    public void updateInfos() {
        if (this.table == null) {
            return;
        }
        int i = 0;
        while (i < this.specs.length) {
            Spec spec = this.specs[i];
            TableItem item = this.table.getItem(i);
            item.setText(1, spec.computeValue());
            ++i;
        }
    }

    @Override
    protected void initContent(final PageContainer container, Composite composite) {
        this.mapBrowser.getGeoMap().addInternalGeoMapListener(this);
        this.addHeaderRow(container, composite, "Actions");
        this.addActionLink(container, composite, "<a>Back to main menu</a>", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                container.showPage(0);
            }
        });
        this.addHeaderRow(container, composite, "Infos");
        this.addInfoText(container, composite, "The following search results were retrieved from openstreetmap.org. Double-click to open a location.");
        this.table = new Table(composite, 68354);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.table, 0);
        column1.setText("Place");
        column1.setWidth(120);
        TableColumn column2 = new TableColumn(this.table, 0);
        column2.setText("Place");
        column2.setWidth(160);
        Spec[] specArray = this.specs;
        int n = this.specs.length;
        int n2 = 0;
        while (n2 < n) {
            Spec spec = specArray[n2];
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, spec.key);
            ++n2;
        }
        this.addHeaderRow(container, composite, "Authors Remarks");
        this.addInfoText(container, composite, "The number of image fetcher threads determines how many background tasks are run simultaneously to fetch tiles. The search is also performed in the background. The tilecache fill never drops below its maximum size once its filled, but the eldest entries are discarded on a LRU (Least-Recently-Used) basis.");
        this.addInfoText(container, composite, "The MapWidget can be used without all of this quite useless showcase application. Its main purpose is to showcase the MapWidget.");
        this.addHeaderRow(container, composite, "Quick Help");
        this.addInfoText(container, composite, "Use the mouse wheel to zoom in and zoom out. Drag the mouse to change your position on the map");
        this.updateInfos();
    }

    @Override
    protected void widgetDisposed(DisposeEvent e) {
        this.mapBrowser.getGeoMap().removeInternalGeoMapListener(this);
    }

    @Override
    public void tilePainted(TileRef tileRef) {
    }

    @Override
    public void mapPainted(int tileCount, long time) {
        this.tilePaintCount = tileCount;
        this.controlPaintTime = time;
    }

    @Override
    public void tileCacheUpdated(int used, int size) {
        this.tileCacheUsed = used;
        this.tileCacheSize = size;
    }

    private abstract class Spec {
        final String key;
        final GeoMap geoMap;

        abstract String computeValue();

        Spec(String key) {
            this.key = key;
            this.geoMap = InfoPage.this.mapBrowser.getGeoMap();
        }
    }
}

