/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.preferencewindow.snippets;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.dialog.Dialog;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWContainer;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWGroup;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWRow;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWTab;
import org.eclipse.nebula.widgets.opal.preferencewindow.PreferenceWindow;
import org.eclipse.nebula.widgets.opal.preferencewindow.enabler.EnabledIfEquals;
import org.eclipse.nebula.widgets.opal.preferencewindow.enabler.EnabledIfTrue;
import org.eclipse.nebula.widgets.opal.preferencewindow.enabler.Enabler;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWButton;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWCheckbox;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWColorChooser;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWCombo;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWDirectoryChooser;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWFileChooser;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWFloatText;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWFontChooser;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWIntegerText;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWLabel;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWPasswordText;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWRadio;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWScale;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWSeparator;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWSpinner;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWStringText;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWTextarea;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWURLText;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWWidget;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PreferenceWindowSnippet {
    public static void main(String[] args) {
        Locale.setDefault(Locale.ENGLISH);
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("PreferenceWindow snippet");
        shell.setLayout((Layout)new FillLayout(512));
        Button button1 = new Button((Composite)shell, 8);
        button1.setText("Open preference window");
        Map<String, Object> data = PreferenceWindowSnippet.fillData();
        button1.addListener(13, e -> {
            PreferenceWindow window = PreferenceWindow.create((Shell)shell, (Map)data);
            PreferenceWindowSnippet.createDocumentTab(window);
            PreferenceWindowSnippet.createInfoTab(window);
            PreferenceWindowSnippet.createTerminalTab(window);
            PreferenceWindowSnippet.createPrinterTab(window);
            PreferenceWindowSnippet.createSystemTab(window);
            window.setSelectedTab(2);
            window.open();
        });
        shell.pack();
        shell.open();
        SWTGraphicUtil.centerShell((Shell)shell);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static Map<String, Object> fillData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("text", "A string");
        data.put("int", 42);
        data.put("float", Float.valueOf(3.14f));
        data.put("url", "http://www.google.fr/");
        data.put("password", "password");
        data.put("directory", "");
        data.put("file", "");
        data.put("textarea", "long long\nlong long\nlong long\ntext...");
        data.put("comboReadOnly", "Value 1");
        data.put("combo", "Other Value");
        data.put("cb1", true);
        data.put("slider", 40);
        data.put("spinner", 30);
        data.put("color", new RGB(120, 15, 30));
        data.put("radio", "Radio button 3");
        data.put("cb3", true);
        data.put("cacheSizeUnit", "Megabytes");
        data.put("openMode", "Double click");
        return data;
    }

    protected static void createDocumentTab(PreferenceWindow window) {
        PWTab documentTab = window.addTab(new Image((Device)Display.getCurrent(), PreferenceWindowSnippet.class.getResourceAsStream("images/document.png")), "Document");
        documentTab.add((PWWidget)new PWLabel("Let's start with Text, Separator, Combo and button")).add(new PWStringText("String :", "text").setAlignment(4)).add((PWWidget)new PWIntegerText("Integer :", "int"));
        documentTab.add((PWWidget)new PWFloatText("Float :", "float"));
        documentTab.add((PWWidget)new PWURLText("URL :", "url"));
        documentTab.add((PWWidget)new PWPasswordText("Password :", "password"));
        documentTab.add((PWWidget)new PWDirectoryChooser("Directory :", "directory"));
        documentTab.add((PWWidget)new PWFileChooser("File :", "file"));
        documentTab.add((PWWidget)new PWTextarea("Textarea :", "textarea"));
        documentTab.add((PWWidget)new PWSeparator());
        documentTab.add((PWWidget)new PWCombo("Combo (read-only):", "comboReadOnly", new Object[]{"Value 1", "Value 2", "Value 3"}));
        documentTab.add((PWWidget)new PWCombo("Combo (editable):", "combo", true, new Object[]{"Value 1", "Value 2", "Value 3"}));
        documentTab.add((PWWidget)new PWSeparator("Titled separator"));
        documentTab.add(new PWButton("First button", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Dialog.inform((String)"Hi", (String)"You pressed the first button");
            }
        }).setAlignment(3));
    }

    protected static void createInfoTab(PreferenceWindow window) {
        PWTab infoTab = window.addTab(new Image((Device)Display.getCurrent(), PreferenceWindowSnippet.class.getResourceAsStream("images/info.png")), "Info");
        infoTab.add((PWWidget)new PWLabel("Checkboxes, Slider,Spinner, Color chooser, Font chooser"));
        infoTab.add((PWWidget)new PWCheckbox("Checkbox 1", "cb1"));
        infoTab.add((PWWidget)new PWCheckbox("Checkbox 2", "cb2"));
        infoTab.add((PWWidget)new PWSeparator());
        infoTab.add((PWWidget)new PWScale("Slider : ", "slider", 0, 100, 10));
        infoTab.add((PWWidget)new PWSpinner("Spinner :", "spinner", 0, 100));
        infoTab.add((PWWidget)new PWSeparator());
        infoTab.add((PWWidget)new PWColorChooser("Color :", "color"));
        infoTab.add((PWWidget)new PWFontChooser("Font :", "font"));
    }

    protected static void createTerminalTab(PreferenceWindow window) {
        PWTab terminalTab = window.addTab(new Image((Device)Display.getCurrent(), PreferenceWindowSnippet.class.getResourceAsStream("images/openterm.png")), "Terminal");
        terminalTab.add((PWWidget)new PWLabel("Group, radio, indentation and group of buttons in a row"));
        PWGroup group = new PWGroup("Group of buttons");
        group.add((PWWidget)new PWRadio("Radio buttons:", "radio", new Object[]{"Radio button 1", "Radio button 2", "Radio button 3"}));
        terminalTab.add((PWContainer)group);
        terminalTab.add(new PWCheckbox("Checkbox 3 (indented)", "cb3").setIndent(30).setWidth(200));
        terminalTab.add(new PWRow().add((PWWidget)new PWButton("First button", (SelectionListener)new SelectionAdapter(){})).add((PWWidget)new PWButton("Second button", (SelectionListener)new SelectionAdapter(){})).add((PWWidget)new PWButton("Third button", (SelectionListener)new SelectionAdapter(){})));
    }

    protected static void createPrinterTab(PreferenceWindow window) {
        PWTab printerTab = window.addTab(new Image((Device)Display.getCurrent(), PreferenceWindowSnippet.class.getResourceAsStream("images/printer.png")), "Printer");
        printerTab.add((PWWidget)new PWLabel("Play <i>with</i> <b>checkboxes</b>"));
        PWGroup group = new PWGroup(false);
        group.add(new PWRow().add((PWWidget)new PWCheckbox("First choice", "cb4")).add((PWWidget)new PWCheckbox("Second choice", "cb5")));
        group.add(new PWRow().add((PWWidget)new PWCheckbox("Third choice", "cb6")).add((PWWidget)new PWCheckbox("Fourth choice", "cb7")));
        group.add(new PWRow().add((PWWidget)new PWCheckbox("Fifth choice", "cb8")).add((PWWidget)new PWCheckbox("Sixth choice", "cb9")));
        group.add(new PWRow().add((PWWidget)new PWCheckbox("Seventh choice", "cb10")).add((PWWidget)new PWCheckbox("Eighth choice", "cb11")));
        printerTab.add((PWContainer)group);
        printerTab.add(new PWRow().add(new PWCheckbox("Automatically check for new versions", "cb12").setWidth(300)).add(new PWButton("Check for updates...", (SelectionListener)new SelectionAdapter(){}).setWidth(250).setAlignment(3)));
        printerTab.add((PWWidget)new PWSeparator());
        PWGroup group2 = new PWGroup(false);
        group2.add(new PWRow().add((PWWidget)new PWLabel("Aligned checkbox")).add((PWWidget)new PWCheckbox("Bla bla bla 1", "cb13")));
        group2.add(new PWRow().add((PWWidget)new PWLabel("")).add((PWWidget)new PWCheckbox("Bla bla bla 2", "cb14")));
        printerTab.add((PWContainer)group2);
    }

    protected static void createSystemTab(PreferenceWindow window) {
        PWTab systemTab = window.addTab(new Image((Device)Display.getCurrent(), PreferenceWindowSnippet.class.getResourceAsStream("images/system.png")), "System");
        systemTab.add((PWWidget)new PWLabel("Rows..."));
        systemTab.add(new PWRow().add((PWWidget)new PWCombo("Cache size", "cacheSize", true, new Object[]{"128", "256", "512", "1024"})).add((PWWidget)new PWCombo(null, "cacheSizeUnit", new Object[]{"Bytes", "Kilobytes", "Megabytes"})));
        systemTab.add(new PWRow().add((PWWidget)new PWCombo("Display:", "display", new Object[]{"10", "20", "30", "40", "50"})).add((PWWidget)new PWLabel("per page")));
        systemTab.add((PWWidget)new PWSeparator());
        systemTab.add((PWWidget)new PWLabel("Enabled/disabled..."));
        systemTab.add(new PWCheckbox("Show information", "show").setWidth(150));
        systemTab.add(new PWGroup("Open Mode").setEnabler((Enabler)new EnabledIfTrue("show")).add((PWWidget)new PWRadio(null, "openMode", new Object[]{"Double click", "Single click"})).add(new PWCheckbox("Select on hover", "selectonhover").setIndent(10).setWidth(200).setEnabler((Enabler)new EnabledIfEquals("openMode", (Object)"Single click"))).add(new PWCheckbox("Open when using arrow keys", "openarrow").setIndent(10).setWidth(200).setEnabler((Enabler)new EnabledIfEquals("openMode", (Object)"Single click"))));
    }
}

