/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline;

import org.eclipse.nebula.widgets.timeline.ITimed;
import org.eclipse.nebula.widgets.timeline.Timing;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;

public class TimeBaseConverter {
    private double fScaleFactor = 1.0;
    private double fDetailScreenWidth = -1.0;
    private Timing fRequiredEventArea = null;
    private double fOffset = 0.0;
    private final RootFigure fRootFigure;
    private int fOverviewScreenWidth = -1;

    public TimeBaseConverter(RootFigure rootFigure) {
        this.fRootFigure = rootFigure;
    }

    public void resetDisplaySettings() {
        this.fScaleFactor = 1.0;
        this.fOffset = this.getEventArea().left();
        this.fRootFigure.fireTimebaseChanged();
    }

    public Timing getVisibleEventArea() {
        Timing visibleArea = new Timing(0.0, this.fDetailScreenWidth);
        visibleArea.scale(1.0 / this.fScaleFactor);
        visibleArea.translate(this.fOffset);
        return visibleArea;
    }

    public long screenOffsetToEventTime(int screenOffset) {
        double offset = screenOffset;
        return Math.round((offset /= this.getScaleFactor()) + this.fOffset);
    }

    public Timing getEventArea() {
        return this.fRequiredEventArea != null ? this.fRequiredEventArea.copy() : new Timing(0.0);
    }

    public void resetEventArea() {
        this.fRequiredEventArea = null;
    }

    public void addEvent(ITimed event) {
        if (this.fRequiredEventArea == null) {
            this.fRequiredEventArea = event.getTiming().copy();
            this.setOffset(event.getTiming().left());
            if (this.fDetailScreenWidth >= 0.0) {
                this.setScaleFactor(this.fDetailScreenWidth / 3.0 / event.getTiming().getDuration(), false);
            }
        } else {
            this.fRequiredEventArea.union(event.getTiming());
        }
    }

    public boolean translateDetailAreaOffset(int screenPixels) {
        return this.translateEventTime(Math.round((double)screenPixels / this.getScaleFactor()));
    }

    private boolean translateEventTime(long eventTime) {
        Timing eventArea = this.getEventArea();
        if (eventTime < 0L) {
            if (this.fOffset > eventArea.left()) {
                this.setOffset(this.fOffset + (double)eventTime);
            }
        } else if (eventTime > 0L) {
            if (this.fOffset < eventArea.right() - this.getVisibleEventArea().getDuration()) {
                this.setOffset(this.fOffset + (double)eventTime);
            }
        } else {
            return false;
        }
        return true;
    }

    public void setScreenWidth(double screenWidth) {
        boolean screenNeedsUpdate = this.fDetailScreenWidth < 0.0;
        this.fDetailScreenWidth = screenWidth;
        if (screenNeedsUpdate) {
            this.fRootFigure.fireTimebaseChanged();
        }
    }

    public void zoom(double factor, int zoomCenterX) {
        long eventTimeAtZoomCenter = this.screenOffsetToEventTime(zoomCenterX);
        this.setScaleFactor(this.fScaleFactor * factor, true);
        long newEventTimeAtZoomCenter = this.screenOffsetToEventTime(zoomCenterX);
        this.setOffset(this.fOffset - (double)newEventTimeAtZoomCenter + (double)eventTimeAtZoomCenter);
    }

    private double getScaleFactor() {
        return this.fScaleFactor;
    }

    public void setOffset(double eventTime) {
        this.fOffset = eventTime;
        this.adjustInvalidOffset();
        this.fRootFigure.fireTimebaseChanged();
    }

    private void setScaleFactor(double scaleFactor, boolean adjust) {
        this.fScaleFactor = scaleFactor;
        if (adjust) {
            double maxScaleFactor = 100.0;
            double minScaleFactor = this.fDetailScreenWidth / this.getEventArea().getDuration();
            this.fScaleFactor = Math.max(minScaleFactor, this.fScaleFactor);
            this.fScaleFactor = Math.min(100.0, this.fScaleFactor);
        }
    }

    private void adjustInvalidOffset() {
        if (this.fOffset > this.getEventArea().right() - this.getVisibleEventArea().getDuration()) {
            this.fOffset = this.getEventArea().right() - this.getVisibleEventArea().getDuration();
        }
        if (this.fOffset < this.getEventArea().left()) {
            this.fOffset = this.getEventArea().left();
        }
    }

    public void revealEvent(Timing revealArea) {
        if (this.getVisibleEventArea().getDuration() <= revealArea.getDuration()) {
            this.fScaleFactor = this.fDetailScreenWidth / (revealArea.getDuration() * 3.0);
        }
        this.setOffset(revealArea.getTimestamp() - (this.getVisibleEventArea().getDuration() - revealArea.getDuration()) / 2.0);
        this.fRootFigure.fireTimebaseChanged();
    }

    private double getOverviewScaleFactor() {
        return (double)this.fOverviewScreenWidth / this.getEventArea().getDuration();
    }

    public boolean translateOverviewAreaOffset(int screenPixels) {
        return this.translateEventTime(Math.round((double)screenPixels / this.getOverviewScaleFactor()));
    }

    public Timing overviewCoordinatesToEventTime(Timing screenCoordinates) {
        Timing eventTime = screenCoordinates.copy();
        eventTime.scale(1.0 / this.getOverviewScaleFactor());
        eventTime.translate(this.getEventArea().left());
        return eventTime;
    }

    public Timing toOverviewScreenCoordinates(Timing eventTime) {
        Timing coordinates = eventTime.copy();
        coordinates.translate(-this.getEventArea().left());
        coordinates.scale(this.getOverviewScaleFactor());
        return coordinates;
    }

    public Timing toDetailCoordinates(Timing eventTime) {
        Timing coordinates = eventTime.copy();
        coordinates.translate(-this.fOffset);
        coordinates.scale(this.getScaleFactor());
        return coordinates;
    }

    public void setOverviewScreenWidth(int widthInPixels) {
        this.fOverviewScreenWidth = widthInPixels;
    }
}

