/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.tablecombo.example;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.examples.ButtonFactory;
import org.eclipse.nebula.examples.ExamplesView;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableItem;

public class TableComboExampleTab
extends AbstractExampleTab {
    private TableCombo tableCombo = null;
    private Button borderStyle;
    private Button readOnlyStyle;
    private Button flatStyle;
    private Button showGrid;
    private Button showHeader;
    private Button showImageInSelection;
    private Button showCustomFontInSelection;
    private Spinner tableWidthPct;
    private Spinner numOfColumnsToDisplaySpinner;
    private Spinner columnIndexToDisplayWhenSelected;
    private Spinner numOfRowsDisplayed;
    private Button showImageInCombo;
    private Button showCustomFontInCombo;
    private Button closePopupAfterSelection;
    private static Font boldFont;
    private static Image testImage;
    private static Image test2Image;
    private static Image test3Image;
    private static Color darkRed;
    private static Color darkBlue;
    private static Color darkGreen;
    private Listener recreateListener = new Listener(){

        public void handleEvent(Event event) {
            TableComboExampleTab.this.recreateExample();
        }
    };

    public TableComboExampleTab() {
        ExamplesView.setFont((String)"tableComboCustFont", (FontData[])new FontData[]{new FontData("Arial", 8, 3)});
        boldFont = ExamplesView.getFont((String)"tableComboCustFont");
        testImage = ExamplesView.getImage((String)"icons/in_ec_ov_success_16x16.gif");
        test2Image = ExamplesView.getImage((String)"icons/in_ec_ov_warning_16x16.gif");
        test3Image = ExamplesView.getImage((String)"icons/invalid_build_tool_16x16.gif");
        darkRed = Display.getCurrent().getSystemColor(4);
        darkBlue = Display.getCurrent().getSystemColor(10);
        darkGreen = Display.getCurrent().getSystemColor(6);
    }

    public Control createControl(Composite parent) {
        int style = 2056;
        if (this.borderStyle.getSelection()) {
            style |= 0x800;
        }
        if (this.readOnlyStyle.getSelection()) {
            style |= 8;
        }
        if (this.flatStyle.getSelection()) {
            style |= 0x800000;
        }
        this.tableCombo = new TableCombo(parent, style);
        this.tableCombo.setShowTableLines(this.showGrid.getSelection());
        this.tableCombo.setShowTableHeader(this.showHeader.getSelection());
        this.tableCombo.setDisplayColumnIndex(this.columnIndexToDisplayWhenSelected.getSelection() - 1);
        this.tableCombo.setShowImageWithinSelection(this.showImageInSelection.getSelection());
        this.tableCombo.setShowColorWithinSelection(this.showCustomFontInSelection.getSelection());
        this.tableCombo.setShowFontWithinSelection(this.showCustomFontInSelection.getSelection());
        this.tableCombo.setClosePopupAfterSelection(this.closePopupAfterSelection.getSelection());
        this.tableCombo.setTableWidthPercentage(this.tableWidthPct.getSelection());
        this.tableCombo.setVisibleItemCount(this.numOfRowsDisplayed.getSelection());
        this.loadData(this.loadModel(), this.tableCombo);
        return this.tableCombo;
    }

    public void createParameters(Composite parent) {
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(parent);
        this.createStyleGroup(parent);
        this.createOptionsGroup(parent);
        this.createSampleDataGroup(parent);
    }

    public String[] createLinks() {
        String[] links = new String[]{"<a href=\"http://www.eclipse.org/nebula/widgets/tablecombo/tablecombo.php\">TableCombo Home Page</a>", "<a href=\"http://www.eclipse.org/nebula/snippets.php#TableCombo\">Snippets</a>", "<a href=\"https://bugs.eclipse.org/bugs/buglist.cgi?query_format=advanced&short_desc_type=allwordssubstr&short_desc=&classification=Technology&product=Nebula&component=TableCombo&long_desc_type=allwordssubstr&long_desc=&bug_file_loc_type=allwordssubstr&bug_file_loc=&status_whiteboard_type=allwordssubstr&status_whiteboard=&keywords_type=allwords&keywords=&emailtype1=substring&email1=&emailtype2=substring&email2=&bugidtype=include&bug_id=&votes=&chfieldfrom=&chfieldto=Now&chfieldvalue=&cmdtype=doit&order=Reuse+same+sort+as+last+time&field0-0-0=noop&type0-0-0=noop&value0-0-0=\">Bugs</a>"};
        return links;
    }

    private void createOptionsGroup(Composite parent) {
        Group gp = new Group(parent, 0);
        gp.setText("Options");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)gp);
        gp.setLayoutData((Object)new GridData(4, 4, false, false));
        GridData gd = new GridData(4, -1, true, false);
        gd.horizontalSpan = 2;
        this.showHeader = ButtonFactory.create((Composite)gp, (int)32, (String)"Show Header", (Listener)this.recreateListener, (boolean)false);
        this.showHeader.setToolTipText("Hides or displays the table column headers.");
        this.showHeader.setLayoutData((Object)gd);
        this.showGrid = ButtonFactory.create((Composite)gp, (int)32, (String)"Show Grid Lines", (Listener)this.recreateListener, (boolean)false);
        this.showGrid.setToolTipText("Hides or displays grid lines in the table.");
        this.showGrid.setLayoutData((Object)gd);
        this.showImageInSelection = ButtonFactory.create((Composite)gp, (int)32, (String)"Show Image In Selection", (Listener)this.recreateListener, (boolean)true);
        this.showImageInSelection.setLayoutData((Object)gd);
        this.showImageInSelection.setToolTipText("Sets whether or not to display the selected table row item's image.");
        this.showCustomFontInSelection = ButtonFactory.create((Composite)gp, (int)32, (String)"Show Custom Font In Selection", (Listener)this.recreateListener, (boolean)true);
        this.showCustomFontInSelection.setLayoutData((Object)gd);
        this.showCustomFontInSelection.setToolTipText("Sets whether or not to display custom fonts in the selected text.");
        this.closePopupAfterSelection = ButtonFactory.create((Composite)gp, (int)32, (String)"Close Popup After Selection", (Listener)this.recreateListener, (boolean)true);
        this.closePopupAfterSelection.setLayoutData((Object)gd);
        this.closePopupAfterSelection.setToolTipText("Sets wheter or not to keep the popup after a selection occured.");
        Label l = new Label((Composite)gp, 0);
        l.setText("Table Width Pct:");
        gd = new GridData(25, -1);
        this.tableWidthPct = new Spinner((Composite)gp, 2048);
        this.tableWidthPct.setValues(100, 25, 100, 0, 1, 1);
        this.tableWidthPct.addListener(13, this.recreateListener);
        this.tableWidthPct.setLayoutData((Object)gd);
        this.tableWidthPct.setToolTipText("Is the percentage of the total table width to display.");
        l = new Label((Composite)gp, 0);
        l.setText("Num Rows Displayed:");
        this.numOfRowsDisplayed = new Spinner((Composite)gp, 2048);
        this.numOfRowsDisplayed.setValues(7, 1, 20, 0, 1, 1);
        this.numOfRowsDisplayed.addListener(13, this.recreateListener);
        this.numOfRowsDisplayed.setLayoutData((Object)gd);
        this.numOfRowsDisplayed.setToolTipText("The number of viewable rows displayed in the table.");
    }

    private void createSampleDataGroup(Composite parent) {
        Group sampleGroup = new Group(parent, 0);
        sampleGroup.setText("Sample Data");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)sampleGroup);
        sampleGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        GridData gd = new GridData(15, -1);
        Label l = new Label((Composite)sampleGroup, 0);
        l.setText("# Columns:");
        l.setToolTipText("Number of Columns To Display In Table.");
        this.numOfColumnsToDisplaySpinner = new Spinner((Composite)sampleGroup, 2048);
        this.numOfColumnsToDisplaySpinner.setValues(1, 1, 3, 0, 1, 1);
        this.numOfColumnsToDisplaySpinner.setToolTipText("Number of Columns To Display In Table.");
        this.numOfColumnsToDisplaySpinner.setLayoutData((Object)gd);
        this.numOfColumnsToDisplaySpinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TableComboExampleTab.this.numOfColumnsToDisplaySpinner.getSelection() == 1) {
                    TableComboExampleTab.this.columnIndexToDisplayWhenSelected.setSelection(1);
                    TableComboExampleTab.this.columnIndexToDisplayWhenSelected.setEnabled(false);
                } else {
                    TableComboExampleTab.this.columnIndexToDisplayWhenSelected.setEnabled(true);
                    TableComboExampleTab.this.columnIndexToDisplayWhenSelected.setMaximum(TableComboExampleTab.this.numOfColumnsToDisplaySpinner.getSelection());
                }
                TableComboExampleTab.this.recreateExample();
            }
        });
        l = new Label((Composite)sampleGroup, 0);
        l.setText("Selected Value:");
        l.setToolTipText("Column to be displayed when selected");
        this.columnIndexToDisplayWhenSelected = new Spinner((Composite)sampleGroup, 2048);
        this.columnIndexToDisplayWhenSelected.setValues(1, 1, 3, 0, 1, 1);
        this.columnIndexToDisplayWhenSelected.addListener(13, this.recreateListener);
        this.columnIndexToDisplayWhenSelected.setEnabled(false);
        this.columnIndexToDisplayWhenSelected.setToolTipText("Column to be displayed when selected");
        this.columnIndexToDisplayWhenSelected.setLayoutData((Object)gd);
        this.showImageInCombo = ButtonFactory.create((Composite)sampleGroup, (int)32, (String)"Include Images", (Listener)this.recreateListener, (boolean)false);
        this.showImageInCombo.setToolTipText("Sets whether or not to include sample images.");
        gd = new GridData(4, -1, true, false);
        gd.horizontalSpan = 2;
        this.showImageInCombo.setLayoutData((Object)gd);
        this.showCustomFontInCombo = ButtonFactory.create((Composite)sampleGroup, (int)32, (String)"Include Fonts", (Listener)this.recreateListener, (boolean)false);
        this.showCustomFontInCombo.setToolTipText("Sets whether or not to include sample fonts.");
        this.showCustomFontInCombo.setLayoutData((Object)gd);
    }

    private void createStyleGroup(Composite parent) {
        Group other = new Group(parent, 0);
        other.setText("Style");
        other.setLayout((Layout)new GridLayout());
        other.setLayoutData((Object)new GridData(1040));
        this.borderStyle = new Button((Composite)other, 32);
        this.borderStyle.setText("SWT.BORDER");
        this.borderStyle.setSelection(true);
        this.borderStyle.addListener(13, this.recreateListener);
        this.readOnlyStyle = new Button((Composite)other, 32);
        this.readOnlyStyle.setText("SWT.READ_ONLY");
        this.readOnlyStyle.setSelection(true);
        this.readOnlyStyle.addListener(13, this.recreateListener);
        this.flatStyle = new Button((Composite)other, 32);
        this.flatStyle.setText("SWT.FLAT");
        this.flatStyle.addListener(13, this.recreateListener);
    }

    private void loadData(List modelList, TableCombo tc) {
        int numCols = this.numOfColumnsToDisplaySpinner.getSelection();
        if (numCols == 1) {
            tc.defineColumns(new String[]{"Id"});
        } else if (numCols == 2) {
            tc.defineColumns(new String[]{"Id", "Description"});
        } else {
            tc.defineColumns(new String[]{"Id", "Description", "Computed"});
        }
        int total = modelList == null ? 0 : modelList.size();
        int index = 0;
        while (index < total) {
            TableItem ti = new TableItem(tc.getTable(), 0);
            Model model = (Model)modelList.get(index);
            if (numCols == 1) {
                ti.setText(0, model.getDescription());
            } else {
                ti.setText(0, String.valueOf(model.getId()));
            }
            if (numCols >= 2) {
                ti.setText(1, model.getDescription());
            }
            if (numCols == 3) {
                ti.setText(2, model.getId() + " - " + model.getDescription());
            }
            if (this.showImageInCombo.getSelection()) {
                if (index == 1 || index == 7 || index == 13 || index == 19) {
                    ti.setImage(0, testImage);
                } else if (index == 3 || index == 9 || index == 15) {
                    ti.setImage(0, test2Image);
                } else if (index == 5 || index == 11 || index == 17) {
                    ti.setImage(0, test3Image);
                }
            }
            if (this.showCustomFontInCombo.getSelection()) {
                if (index == 0 || index == 14) {
                    ti.setForeground(darkRed);
                    ti.setFont(boldFont);
                } else if (index == 4 || index == 19) {
                    ti.setForeground(darkBlue);
                    ti.setFont(boldFont);
                } else if (index == 9) {
                    ti.setForeground(darkGreen);
                    ti.setFont(boldFont);
                }
            }
            ++index;
        }
    }

    private List loadModel() {
        ArrayList<Model> items = new ArrayList<Model>();
        items.add(new Model(1, "One"));
        items.add(new Model(2, "Two"));
        items.add(new Model(3, "Three"));
        items.add(new Model(4, "Four"));
        items.add(new Model(5, "Five"));
        items.add(new Model(6, "Six"));
        items.add(new Model(7, "Seven"));
        items.add(new Model(8, "Eight"));
        items.add(new Model(9, "Nine"));
        items.add(new Model(10, "Ten"));
        items.add(new Model(11, "Eleven"));
        items.add(new Model(12, "Twelve"));
        items.add(new Model(13, "Thirteen"));
        items.add(new Model(14, "Fourteen"));
        items.add(new Model(15, "Fiveteen"));
        items.add(new Model(16, "Sixteen"));
        items.add(new Model(17, "Seventeen"));
        items.add(new Model(18, "Eighteen"));
        items.add(new Model(19, "Nineteen"));
        items.add(new Model(20, "Twenty"));
        return items;
    }

    private class Model {
        private int id;
        private String description;

        public Model(int id, String description) {
            this.id = id;
            this.description = description;
        }

        public int getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Model other = (Model)obj;
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            return this.id == other.id;
        }

        public String toString() {
            return "[id=" + this.id + "] [description=" + this.description + "]";
        }
    }
}

