/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.passwordrevealer;

import org.eclipse.nebula.widgets.passwordrevealer.EyeButton;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class PasswordRevealer
extends Composite {
    protected Text passwordField;
    private final EyeButton eyeButton;
    private final char defaultEchoChar;
    private boolean isPushMode;

    public PasswordRevealer(Composite parent, int style) {
        super(parent, 2048);
        this.isPushMode = (style & 8) == 8;
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginBottom = 0;
        this.setLayout((Layout)gl);
        super.setBackground(parent.getBackground());
        this.passwordField = new Text((Composite)this, this.removeFields(style, 2048, 8) | 0x400000);
        this.passwordField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.defaultEchoChar = this.passwordField.getEchoChar();
        this.eyeButton = new EyeButton(this, this.isPushMode ? 8 : 0);
        this.eyeButton.setLayoutData(new GridData(4, 4, false, false));
    }

    private int removeFields(int original, int ... styles) {
        int returnedStyle = original;
        int[] nArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            int toBeRemoved = nArray[n2];
            if ((returnedStyle & toBeRemoved) != 0) {
                returnedStyle &= ~toBeRemoved;
            }
            ++n2;
        }
        return returnedStyle;
    }

    void revealPassword() {
        this.passwordField.setEchoChar('\u0000');
    }

    void hidePassword() {
        this.passwordField.setEchoChar(this.defaultEchoChar);
    }

    public void addModifyListener(ModifyListener listener) {
        this.passwordField.addModifyListener(listener);
    }

    public void addSegmentListener(SegmentListener listener) {
        this.passwordField.addSegmentListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.passwordField.addSelectionListener(listener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.passwordField.addVerifyListener(listener);
    }

    public void append(String string) {
        this.passwordField.append(string);
    }

    public void clearSelection() {
        this.passwordField.clearSelection();
    }

    public void copy() {
        this.passwordField.copy();
    }

    public void cut() {
        this.passwordField.cut();
    }

    public int getCaretLineNumber() {
        return this.passwordField.getCaretLineNumber();
    }

    public Point getCaretLocation() {
        return this.passwordField.getCaretLocation();
    }

    public int getCaretPosition() {
        return this.passwordField.getCaretPosition();
    }

    public int getCharCount() {
        return this.passwordField.getCharCount();
    }

    public Image getClickImage() {
        this.checkWidget();
        return this.eyeButton.getClickImage();
    }

    public boolean getDoubleClickEnabled() {
        return this.passwordField.getDoubleClickEnabled();
    }

    public char getEchoChar() {
        return this.passwordField.getEchoChar();
    }

    public boolean getEditable() {
        return this.passwordField.getEditable();
    }

    public Image getImage() {
        this.checkWidget();
        return this.eyeButton.getImage();
    }

    public int getLineCount() {
        return this.passwordField.getLineCount();
    }

    public String getLineDelimiter() {
        return this.passwordField.getLineDelimiter();
    }

    public int getLineHeight() {
        return this.passwordField.getLineHeight();
    }

    public String getMessage() {
        return this.passwordField.getMessage();
    }

    public Point getSelection() {
        return this.passwordField.getSelection();
    }

    public int getSelectionCount() {
        return this.passwordField.getSelectionCount();
    }

    public String getSelectionText() {
        return this.passwordField.getSelectionText();
    }

    public int getTabs() {
        return this.passwordField.getTabs();
    }

    public String getText() {
        return this.passwordField.getText();
    }

    public char[] getTextChars() {
        return this.passwordField.getTextChars();
    }

    public String getText(int start, int end) {
        return this.passwordField.getText(start, end);
    }

    public int getTextLimit() {
        return this.passwordField.getTextLimit();
    }

    public int getTopIndex() {
        return this.passwordField.getTopIndex();
    }

    public int getTopPixel() {
        return this.passwordField.getTopPixel();
    }

    public void insert(String string) {
        this.passwordField.insert(string);
    }

    public void paste() {
        this.passwordField.paste();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.passwordField.removeModifyListener(listener);
    }

    public void removeSegmentListener(SegmentListener listener) {
        this.passwordField.removeSegmentListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.passwordField.removeSelectionListener(listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.passwordField.removeVerifyListener(listener);
    }

    public void selectAll() {
        this.passwordField.selectAll();
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.passwordField.setDoubleClickEnabled(doubleClick);
    }

    public void setEchoChar(char echo) {
        this.passwordField.setEchoChar(echo);
    }

    public void setEditable(boolean editable) {
        this.passwordField.setEditable(editable);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.passwordField.setFont(font);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.eyeButton.setImage(image);
    }

    public void setMessage(String message) {
        this.passwordField.setMessage(message);
    }

    public void setOrientation(int orientation) {
        this.passwordField.setOrientation(orientation);
    }

    public void setPushMode(boolean pushMode) {
        this.checkWidget();
        this.isPushMode = pushMode;
        this.eyeButton.setPushMode(pushMode);
    }

    public void setSelection(int start) {
        this.passwordField.setSelection(start);
    }

    public void setSelection(int start, int end) {
        this.passwordField.setSelection(start, end);
    }

    public void setSelection(Point selection) {
        this.passwordField.setSelection(selection);
    }

    public void setTabs(int tabs) {
        this.passwordField.setTabs(tabs);
    }

    public void setText(String string) {
        this.passwordField.setText(string);
    }

    public void setTextChars(char[] text) {
        this.passwordField.setTextChars(text);
    }

    public void setTextLimit(int limit) {
        this.passwordField.setTextLimit(limit);
    }

    public void setTopIndex(int index) {
        this.passwordField.setTopIndex(index);
    }

    public void showSelection() {
        this.passwordField.showSelection();
    }

    public void addDragDetectListener(DragDetectListener listener) {
        super.addDragDetectListener(listener);
        this.eyeButton.addDragDetectListener(listener);
        this.passwordField.addDragDetectListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        this.eyeButton.addFocusListener(listener);
        this.passwordField.addFocusListener(listener);
    }

    public void addGestureListener(GestureListener listener) {
        super.addGestureListener(listener);
        this.eyeButton.addGestureListener(listener);
        this.passwordField.addGestureListener(listener);
    }

    public void addHelpListener(HelpListener listener) {
        super.addHelpListener(listener);
        this.eyeButton.addHelpListener(listener);
        this.passwordField.addHelpListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        super.addKeyListener(listener);
        this.eyeButton.addKeyListener(listener);
        this.passwordField.addKeyListener(listener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        super.addMenuDetectListener(listener);
        this.eyeButton.addMenuDetectListener(listener);
        this.passwordField.addMenuDetectListener(listener);
    }

    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        this.eyeButton.addMouseListener(listener);
        this.passwordField.addMouseListener(listener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        super.addMouseTrackListener(listener);
        this.eyeButton.addMouseTrackListener(listener);
        this.passwordField.addMouseTrackListener(listener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        super.addMouseMoveListener(listener);
        this.eyeButton.addMouseMoveListener(listener);
        this.passwordField.addMouseMoveListener(listener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        super.addMouseWheelListener(listener);
        this.eyeButton.addMouseWheelListener(listener);
        this.passwordField.addMouseWheelListener(listener);
    }

    public void addTouchListener(TouchListener listener) {
        super.addTouchListener(listener);
        this.eyeButton.addTouchListener(listener);
        this.passwordField.addTouchListener(listener);
    }

    public boolean forceFocus() {
        return this.passwordField.forceFocus();
    }

    public boolean isFocusControl() {
        return this.passwordField.isFocusControl();
    }

    public boolean isPushMode() {
        this.checkWidget();
        return this.isPushMode;
    }

    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        this.eyeButton.removeFocusListener(listener);
        this.passwordField.removeFocusListener(listener);
    }

    public void removeGestureListener(GestureListener listener) {
        super.removeGestureListener(listener);
        this.eyeButton.removeGestureListener(listener);
        this.passwordField.removeGestureListener(listener);
    }

    public void removeHelpListener(HelpListener listener) {
        super.removeHelpListener(listener);
        this.eyeButton.removeHelpListener(listener);
        this.passwordField.removeHelpListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        super.removeKeyListener(listener);
        this.eyeButton.removeKeyListener(listener);
        this.passwordField.removeKeyListener(listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        super.removeMenuDetectListener(listener);
        this.eyeButton.removeMenuDetectListener(listener);
        this.passwordField.removeMenuDetectListener(listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        super.removeMouseTrackListener(listener);
        this.eyeButton.removeMouseTrackListener(listener);
        this.passwordField.removeMouseTrackListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        super.removeMouseListener(listener);
        this.eyeButton.removeMouseListener(listener);
        this.passwordField.removeMouseListener(listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        super.removeMouseMoveListener(listener);
        this.eyeButton.removeMouseMoveListener(listener);
        this.passwordField.removeMouseMoveListener(listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        super.removeMouseWheelListener(listener);
        this.eyeButton.removeMouseWheelListener(listener);
        this.passwordField.removeMouseWheelListener(listener);
    }

    public void removeTouchListener(TouchListener listener) {
        super.removeTouchListener(listener);
        this.eyeButton.removeTouchListener(listener);
        this.passwordField.removeTouchListener(listener);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.eyeButton.setBackground(color);
        this.passwordField.setBackground(color);
    }

    public void setCapture(boolean capture) {
        super.setCapture(capture);
        this.eyeButton.setCapture(capture);
        this.passwordField.setCapture(capture);
    }

    public void setClickImage(Image image) {
        this.checkWidget();
        this.eyeButton.setClickImage(image);
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.eyeButton.setCursor(cursor);
        this.passwordField.setCursor(cursor);
    }

    public void setDragDetect(boolean dragDetect) {
        super.setDragDetect(dragDetect);
        this.eyeButton.setDragDetect(dragDetect);
        this.passwordField.setDragDetect(dragDetect);
    }

    public boolean setFocus() {
        return this.passwordField.setFocus();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.eyeButton.setForeground(color);
        this.passwordField.setForeground(color);
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.eyeButton.setMenu(menu);
        this.passwordField.setMenu(menu);
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.eyeButton.setToolTipText(string);
        this.passwordField.setToolTipText(string);
    }

    public void setTouchEnabled(boolean enabled) {
        super.setTouchEnabled(enabled);
        this.eyeButton.setTouchEnabled(enabled);
        this.passwordField.setTouchEnabled(enabled);
    }

    public boolean traverse(int traversal) {
        return this.passwordField.traverse(traversal);
    }

    public boolean traverse(int traversal, Event event) {
        return this.passwordField.traverse(traversal, event);
    }

    public boolean traverse(int traversal, KeyEvent event) {
        this.checkWidget();
        return this.passwordField.traverse(traversal, event);
    }
}

